// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.resourcemanager.keyvault.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Activation Status.
 */
public final class ActivationStatus extends ExpandableStringEnum<ActivationStatus> {
    /**
     * The managed HSM Pool is active.
     */
    public static final ActivationStatus ACTIVE = fromString("Active");

    /**
     * The managed HSM Pool is not yet activated.
     */
    public static final ActivationStatus NOT_ACTIVATED = fromString("NotActivated");

    /**
     * An unknown error occurred while activating managed hsm.
     */
    public static final ActivationStatus UNKNOWN = fromString("Unknown");

    /**
     * Failed to activate managed hsm.
     */
    public static final ActivationStatus FAILED = fromString("Failed");

    /**
     * Creates a new instance of ActivationStatus value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public ActivationStatus() {
    }

    /**
     * Creates or finds a ActivationStatus from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding ActivationStatus.
     */
    public static ActivationStatus fromString(String name) {
        return fromString(name, ActivationStatus.class);
    }

    /**
     * Gets known ActivationStatus values.
     * 
     * @return known ActivationStatus values.
     */
    public static Collection<ActivationStatus> values() {
        return values(ActivationStatus.class);
    }
}
