// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.resourcemanager.keyvault.implementation.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The list of vault resources.
 */
@Immutable
public final class ResourceListResult implements JsonSerializable<ResourceListResult> {
    /*
     * The list of vault resources.
     */
    private List<Resource> value;

    /*
     * The URL to get the next set of vault resources.
     */
    private String nextLink;

    /**
     * Creates an instance of ResourceListResult class.
     */
    private ResourceListResult() {
    }

    /**
     * Get the value property: The list of vault resources.
     * 
     * @return the value value.
     */
    public List<Resource> value() {
        return this.value;
    }

    /**
     * Get the nextLink property: The URL to get the next set of vault resources.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property value in model ResourceListResult"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ResourceListResult.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResourceListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResourceListResult if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ResourceListResult.
     */
    public static ResourceListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ResourceListResult deserializedResourceListResult = new ResourceListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<Resource> value = reader.readArray(reader1 -> Resource.fromJson(reader1));
                    deserializedResourceListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedResourceListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedResourceListResult;
        });
    }
}
