// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.resourcemanager.keyvault.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.keyvault.fluent.ManagedHsmsClient;
import com.azure.resourcemanager.keyvault.fluent.models.CheckMhsmNameAvailabilityResultInner;
import com.azure.resourcemanager.keyvault.fluent.models.DeletedManagedHsmInner;
import com.azure.resourcemanager.keyvault.fluent.models.ManagedHsmInner;
import com.azure.resourcemanager.keyvault.implementation.models.DeletedManagedHsmListResult;
import com.azure.resourcemanager.keyvault.implementation.models.ManagedHsmListResult;
import com.azure.resourcemanager.keyvault.models.CheckMhsmNameAvailabilityParameters;
import com.azure.resourcemanager.keyvault.models.ErrorException;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsGet;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in ManagedHsmsClient.
 */
public final class ManagedHsmsClientImpl implements InnerSupportsGet<ManagedHsmInner>,
    InnerSupportsListing<ManagedHsmInner>, InnerSupportsDelete<Void>, ManagedHsmsClient {
    /**
     * The proxy service used to perform REST calls.
     */
    private final ManagedHsmsService service;

    /**
     * The service client containing this operation class.
     */
    private final KeyVaultManagementClientImpl client;

    /**
     * Initializes an instance of ManagedHsmsClientImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    ManagedHsmsClientImpl(KeyVaultManagementClientImpl client) {
        this.service
            = RestProxy.create(ManagedHsmsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for KeyVaultManagementClientManagedHsms to be used by the proxy service
     * to perform REST calls.
     */
    @Host("{endpoint}")
    @ServiceInterface(name = "KeyVaultManagementClientManagedHsms")
    public interface ManagedHsmsService {
        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/managedHSMs/{name}")
        @ExpectedResponses({ 200, 204 })
        @UnexpectedResponseExceptionType(ErrorException.class)
        Mono<Response<ManagedHsmInner>> getByResourceGroup(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/managedHSMs/{name}")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(ErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @HeaderParam("Content-Type") String contentType, @HeaderParam("Accept") String accept,
            @BodyParam("application/json") ManagedHsmInner parameters, Context context);

        @Patch("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/managedHSMs/{name}")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(ErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> update(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @HeaderParam("Content-Type") String contentType, @HeaderParam("Accept") String accept,
            @BodyParam("application/json") ManagedHsmInner parameters, Context context);

        @Headers({ "Accept: application/json;q=0.9", "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/managedHSMs/{name}")
        @ExpectedResponses({ 200, 202, 204 })
        @UnexpectedResponseExceptionType(ErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> delete(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/managedHSMs")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ErrorException.class)
        Mono<Response<ManagedHsmListResult>> listByResourceGroup(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @QueryParam("$top") Integer top,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/providers/Microsoft.KeyVault/managedHSMs")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ErrorException.class)
        Mono<Response<ManagedHsmListResult>> list(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("$top") Integer top, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/providers/Microsoft.KeyVault/locations/{location}/deletedManagedHSMs/{name}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ErrorException.class)
        Mono<Response<DeletedManagedHsmInner>> getDeleted(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("location") String location, @PathParam("name") String name,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Accept: application/json;q=0.9", "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/providers/Microsoft.KeyVault/locations/{location}/deletedManagedHSMs/{name}/purge")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> purgeDeleted(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("location") String location, @PathParam("name") String name, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/providers/Microsoft.KeyVault/deletedManagedHSMs")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ErrorException.class)
        Mono<Response<DeletedManagedHsmListResult>> listDeleted(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @HeaderParam("Accept") String accept, Context context);

        @Post("/subscriptions/{subscriptionId}/providers/Microsoft.KeyVault/checkMhsmNameAvailability")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<CheckMhsmNameAvailabilityResultInner>> checkMhsmNameAvailability(
            @HostParam("endpoint") String endpoint, @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId, @HeaderParam("Content-Type") String contentType,
            @HeaderParam("Accept") String accept,
            @BodyParam("application/json") CheckMhsmNameAvailabilityParameters mhsmName, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ErrorException.class)
        Mono<Response<ManagedHsmListResult>> listByResourceGroupNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("endpoint") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ErrorException.class)
        Mono<Response<ManagedHsmListResult>> listBySubscriptionNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("endpoint") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ErrorException.class)
        Mono<Response<DeletedManagedHsmListResult>> listDeletedNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("endpoint") String endpoint,
            @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Gets the specified managed HSM Pool.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the managed HSM Pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified managed HSM Pool along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ManagedHsmInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getByResourceGroup(this.client.getEndpoint(), this.client.getApiVersion(),
                this.client.getSubscriptionId(), resourceGroupName, name, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the specified managed HSM Pool.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the managed HSM Pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified managed HSM Pool along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<ManagedHsmInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String name,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getByResourceGroup(this.client.getEndpoint(), this.client.getApiVersion(),
            this.client.getSubscriptionId(), resourceGroupName, name, accept, context);
    }

    /**
     * Gets the specified managed HSM Pool.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the managed HSM Pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified managed HSM Pool on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ManagedHsmInner> getByResourceGroupAsync(String resourceGroupName, String name) {
        return getByResourceGroupWithResponseAsync(resourceGroupName, name)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the specified managed HSM Pool.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the managed HSM Pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified managed HSM Pool along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ManagedHsmInner> getByResourceGroupWithResponse(String resourceGroupName, String name,
        Context context) {
        return getByResourceGroupWithResponseAsync(resourceGroupName, name, context).block();
    }

    /**
     * Gets the specified managed HSM Pool.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the managed HSM Pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified managed HSM Pool.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ManagedHsmInner getByResourceGroup(String resourceGroupName, String name) {
        return getByResourceGroupWithResponse(resourceGroupName, name, Context.NONE).getValue();
    }

    /**
     * Create or update a managed HSM Pool in the specified subscription.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the managed HSM Pool.
     * @param parameters Parameters to create or update the managed HSM Pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return resource information with extended details along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String name,
        ManagedHsmInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String contentType = "application/json";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createOrUpdate(this.client.getEndpoint(), this.client.getApiVersion(),
                this.client.getSubscriptionId(), resourceGroupName, name, contentType, accept, parameters, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Create or update a managed HSM Pool in the specified subscription.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the managed HSM Pool.
     * @param parameters Parameters to create or update the managed HSM Pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return resource information with extended details along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String name,
        ManagedHsmInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String contentType = "application/json";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createOrUpdate(this.client.getEndpoint(), this.client.getApiVersion(),
            this.client.getSubscriptionId(), resourceGroupName, name, contentType, accept, parameters, context);
    }

    /**
     * Create or update a managed HSM Pool in the specified subscription.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the managed HSM Pool.
     * @param parameters Parameters to create or update the managed HSM Pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of resource information with extended details.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<ManagedHsmInner>, ManagedHsmInner> beginCreateOrUpdateAsync(String resourceGroupName,
        String name, ManagedHsmInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = createOrUpdateWithResponseAsync(resourceGroupName, name, parameters);
        return this.client.<ManagedHsmInner, ManagedHsmInner>getLroResult(mono, this.client.getHttpPipeline(),
            ManagedHsmInner.class, ManagedHsmInner.class, this.client.getContext());
    }

    /**
     * Create or update a managed HSM Pool in the specified subscription.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the managed HSM Pool.
     * @param parameters Parameters to create or update the managed HSM Pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of resource information with extended details.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ManagedHsmInner>, ManagedHsmInner> beginCreateOrUpdateAsync(String resourceGroupName,
        String name, ManagedHsmInner parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = createOrUpdateWithResponseAsync(resourceGroupName, name, parameters, context);
        return this.client.<ManagedHsmInner, ManagedHsmInner>getLroResult(mono, this.client.getHttpPipeline(),
            ManagedHsmInner.class, ManagedHsmInner.class, context);
    }

    /**
     * Create or update a managed HSM Pool in the specified subscription.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the managed HSM Pool.
     * @param parameters Parameters to create or update the managed HSM Pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of resource information with extended details.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ManagedHsmInner>, ManagedHsmInner> beginCreateOrUpdate(String resourceGroupName,
        String name, ManagedHsmInner parameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, name, parameters).getSyncPoller();
    }

    /**
     * Create or update a managed HSM Pool in the specified subscription.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the managed HSM Pool.
     * @param parameters Parameters to create or update the managed HSM Pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of resource information with extended details.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ManagedHsmInner>, ManagedHsmInner> beginCreateOrUpdate(String resourceGroupName,
        String name, ManagedHsmInner parameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, name, parameters, context).getSyncPoller();
    }

    /**
     * Create or update a managed HSM Pool in the specified subscription.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the managed HSM Pool.
     * @param parameters Parameters to create or update the managed HSM Pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return resource information with extended details on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ManagedHsmInner> createOrUpdateAsync(String resourceGroupName, String name,
        ManagedHsmInner parameters) {
        return beginCreateOrUpdateAsync(resourceGroupName, name, parameters).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Create or update a managed HSM Pool in the specified subscription.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the managed HSM Pool.
     * @param parameters Parameters to create or update the managed HSM Pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return resource information with extended details on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<ManagedHsmInner> createOrUpdateAsync(String resourceGroupName, String name, ManagedHsmInner parameters,
        Context context) {
        return beginCreateOrUpdateAsync(resourceGroupName, name, parameters, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Create or update a managed HSM Pool in the specified subscription.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the managed HSM Pool.
     * @param parameters Parameters to create or update the managed HSM Pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return resource information with extended details.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ManagedHsmInner createOrUpdate(String resourceGroupName, String name, ManagedHsmInner parameters) {
        return createOrUpdateAsync(resourceGroupName, name, parameters).block();
    }

    /**
     * Create or update a managed HSM Pool in the specified subscription.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the managed HSM Pool.
     * @param parameters Parameters to create or update the managed HSM Pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return resource information with extended details.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ManagedHsmInner createOrUpdate(String resourceGroupName, String name, ManagedHsmInner parameters,
        Context context) {
        return createOrUpdateAsync(resourceGroupName, name, parameters, context).block();
    }

    /**
     * Update a managed HSM Pool in the specified subscription.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the managed HSM Pool.
     * @param parameters Parameters to patch the managed HSM Pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return resource information with extended details along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String name,
        ManagedHsmInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String contentType = "application/json";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.update(this.client.getEndpoint(), this.client.getApiVersion(),
                this.client.getSubscriptionId(), resourceGroupName, name, contentType, accept, parameters, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Update a managed HSM Pool in the specified subscription.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the managed HSM Pool.
     * @param parameters Parameters to patch the managed HSM Pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return resource information with extended details along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String name,
        ManagedHsmInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String contentType = "application/json";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.update(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(),
            resourceGroupName, name, contentType, accept, parameters, context);
    }

    /**
     * Update a managed HSM Pool in the specified subscription.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the managed HSM Pool.
     * @param parameters Parameters to patch the managed HSM Pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of resource information with extended details.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<ManagedHsmInner>, ManagedHsmInner> beginUpdateAsync(String resourceGroupName,
        String name, ManagedHsmInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = updateWithResponseAsync(resourceGroupName, name, parameters);
        return this.client.<ManagedHsmInner, ManagedHsmInner>getLroResult(mono, this.client.getHttpPipeline(),
            ManagedHsmInner.class, ManagedHsmInner.class, this.client.getContext());
    }

    /**
     * Update a managed HSM Pool in the specified subscription.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the managed HSM Pool.
     * @param parameters Parameters to patch the managed HSM Pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of resource information with extended details.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ManagedHsmInner>, ManagedHsmInner> beginUpdateAsync(String resourceGroupName,
        String name, ManagedHsmInner parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = updateWithResponseAsync(resourceGroupName, name, parameters, context);
        return this.client.<ManagedHsmInner, ManagedHsmInner>getLroResult(mono, this.client.getHttpPipeline(),
            ManagedHsmInner.class, ManagedHsmInner.class, context);
    }

    /**
     * Update a managed HSM Pool in the specified subscription.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the managed HSM Pool.
     * @param parameters Parameters to patch the managed HSM Pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of resource information with extended details.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ManagedHsmInner>, ManagedHsmInner> beginUpdate(String resourceGroupName, String name,
        ManagedHsmInner parameters) {
        return this.beginUpdateAsync(resourceGroupName, name, parameters).getSyncPoller();
    }

    /**
     * Update a managed HSM Pool in the specified subscription.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the managed HSM Pool.
     * @param parameters Parameters to patch the managed HSM Pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of resource information with extended details.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ManagedHsmInner>, ManagedHsmInner> beginUpdate(String resourceGroupName, String name,
        ManagedHsmInner parameters, Context context) {
        return this.beginUpdateAsync(resourceGroupName, name, parameters, context).getSyncPoller();
    }

    /**
     * Update a managed HSM Pool in the specified subscription.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the managed HSM Pool.
     * @param parameters Parameters to patch the managed HSM Pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return resource information with extended details on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ManagedHsmInner> updateAsync(String resourceGroupName, String name, ManagedHsmInner parameters) {
        return beginUpdateAsync(resourceGroupName, name, parameters).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Update a managed HSM Pool in the specified subscription.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the managed HSM Pool.
     * @param parameters Parameters to patch the managed HSM Pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return resource information with extended details on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<ManagedHsmInner> updateAsync(String resourceGroupName, String name, ManagedHsmInner parameters,
        Context context) {
        return beginUpdateAsync(resourceGroupName, name, parameters, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Update a managed HSM Pool in the specified subscription.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the managed HSM Pool.
     * @param parameters Parameters to patch the managed HSM Pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return resource information with extended details.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ManagedHsmInner update(String resourceGroupName, String name, ManagedHsmInner parameters) {
        return updateAsync(resourceGroupName, name, parameters).block();
    }

    /**
     * Update a managed HSM Pool in the specified subscription.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the managed HSM Pool.
     * @param parameters Parameters to patch the managed HSM Pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return resource information with extended details.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ManagedHsmInner update(String resourceGroupName, String name, ManagedHsmInner parameters, Context context) {
        return updateAsync(resourceGroupName, name, parameters, context).block();
    }

    /**
     * Deletes the specified managed HSM Pool.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the managed HSM Pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.delete(this.client.getEndpoint(), this.client.getApiVersion(),
                this.client.getSubscriptionId(), resourceGroupName, name, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deletes the specified managed HSM Pool.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the managed HSM Pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String name,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(),
            resourceGroupName, name, context);
    }

    /**
     * Deletes the specified managed HSM Pool.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the managed HSM Pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String name) {
        Mono<Response<Flux<ByteBuffer>>> mono = deleteWithResponseAsync(resourceGroupName, name);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            this.client.getContext());
    }

    /**
     * Deletes the specified managed HSM Pool.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the managed HSM Pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String name,
        Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = deleteWithResponseAsync(resourceGroupName, name, context);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            context);
    }

    /**
     * Deletes the specified managed HSM Pool.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the managed HSM Pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String name) {
        return this.beginDeleteAsync(resourceGroupName, name).getSyncPoller();
    }

    /**
     * Deletes the specified managed HSM Pool.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the managed HSM Pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String name, Context context) {
        return this.beginDeleteAsync(resourceGroupName, name, context).getSyncPoller();
    }

    /**
     * Deletes the specified managed HSM Pool.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the managed HSM Pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String name) {
        return beginDeleteAsync(resourceGroupName, name).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes the specified managed HSM Pool.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the managed HSM Pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String name, Context context) {
        return beginDeleteAsync(resourceGroupName, name, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes the specified managed HSM Pool.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the managed HSM Pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String name) {
        deleteAsync(resourceGroupName, name).block();
    }

    /**
     * Deletes the specified managed HSM Pool.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the managed HSM Pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String name, Context context) {
        deleteAsync(resourceGroupName, name, context).block();
    }

    /**
     * The List operation gets information about the managed HSM Pools associated with the subscription and within the
     * specified resource group.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param top Maximum number of results to return.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of a ManagedHsm list operation along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ManagedHsmInner>> listByResourceGroupSinglePageAsync(String resourceGroupName,
        Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listByResourceGroup(this.client.getEndpoint(), this.client.getApiVersion(),
                this.client.getSubscriptionId(), resourceGroupName, top, accept, context))
            .<PagedResponse<ManagedHsmInner>>map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(),
                res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * The List operation gets information about the managed HSM Pools associated with the subscription and within the
     * specified resource group.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param top Maximum number of results to return.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of a ManagedHsm list operation along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ManagedHsmInner>> listByResourceGroupSinglePageAsync(String resourceGroupName,
        Integer top, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listByResourceGroup(this.client.getEndpoint(), this.client.getApiVersion(),
                this.client.getSubscriptionId(), resourceGroupName, top, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * The List operation gets information about the managed HSM Pools associated with the subscription and within the
     * specified resource group.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param top Maximum number of results to return.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of a ManagedHsm list operation as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<ManagedHsmInner> listByResourceGroupAsync(String resourceGroupName, Integer top) {
        return new PagedFlux<>(() -> listByResourceGroupSinglePageAsync(resourceGroupName, top),
            nextLink -> listByResourceGroupNextSinglePageAsync(nextLink));
    }

    /**
     * The List operation gets information about the managed HSM Pools associated with the subscription and within the
     * specified resource group.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of a ManagedHsm list operation as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<ManagedHsmInner> listByResourceGroupAsync(String resourceGroupName) {
        final Integer top = null;
        return new PagedFlux<>(() -> listByResourceGroupSinglePageAsync(resourceGroupName, top),
            nextLink -> listByResourceGroupNextSinglePageAsync(nextLink));
    }

    /**
     * The List operation gets information about the managed HSM Pools associated with the subscription and within the
     * specified resource group.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param top Maximum number of results to return.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of a ManagedHsm list operation as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<ManagedHsmInner> listByResourceGroupAsync(String resourceGroupName, Integer top,
        Context context) {
        return new PagedFlux<>(() -> listByResourceGroupSinglePageAsync(resourceGroupName, top, context),
            nextLink -> listByResourceGroupNextSinglePageAsync(nextLink, context));
    }

    /**
     * The List operation gets information about the managed HSM Pools associated with the subscription and within the
     * specified resource group.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of a ManagedHsm list operation as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ManagedHsmInner> listByResourceGroup(String resourceGroupName) {
        final Integer top = null;
        return new PagedIterable<>(listByResourceGroupAsync(resourceGroupName, top));
    }

    /**
     * The List operation gets information about the managed HSM Pools associated with the subscription and within the
     * specified resource group.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param top Maximum number of results to return.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of a ManagedHsm list operation as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ManagedHsmInner> listByResourceGroup(String resourceGroupName, Integer top, Context context) {
        return new PagedIterable<>(listByResourceGroupAsync(resourceGroupName, top, context));
    }

    /**
     * The List operation gets information about the managed HSM Pools associated with the subscription.
     * 
     * @param top Maximum number of results to return.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of a ManagedHsm list operation along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ManagedHsmInner>> listSinglePageAsync(Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.list(this.client.getEndpoint(), this.client.getApiVersion(),
                this.client.getSubscriptionId(), top, accept, context))
            .<PagedResponse<ManagedHsmInner>>map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(),
                res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * The List operation gets information about the managed HSM Pools associated with the subscription.
     * 
     * @param top Maximum number of results to return.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of a ManagedHsm list operation along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ManagedHsmInner>> listSinglePageAsync(Integer top, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), top, accept,
                context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * The List operation gets information about the managed HSM Pools associated with the subscription.
     * 
     * @param top Maximum number of results to return.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of a ManagedHsm list operation as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<ManagedHsmInner> listAsync(Integer top) {
        return new PagedFlux<>(() -> listSinglePageAsync(top),
            nextLink -> listBySubscriptionNextSinglePageAsync(nextLink));
    }

    /**
     * The List operation gets information about the managed HSM Pools associated with the subscription.
     * 
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of a ManagedHsm list operation as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<ManagedHsmInner> listAsync() {
        final Integer top = null;
        return new PagedFlux<>(() -> listSinglePageAsync(top),
            nextLink -> listBySubscriptionNextSinglePageAsync(nextLink));
    }

    /**
     * The List operation gets information about the managed HSM Pools associated with the subscription.
     * 
     * @param top Maximum number of results to return.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of a ManagedHsm list operation as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<ManagedHsmInner> listAsync(Integer top, Context context) {
        return new PagedFlux<>(() -> listSinglePageAsync(top, context),
            nextLink -> listBySubscriptionNextSinglePageAsync(nextLink, context));
    }

    /**
     * The List operation gets information about the managed HSM Pools associated with the subscription.
     * 
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of a ManagedHsm list operation as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ManagedHsmInner> list() {
        final Integer top = null;
        return new PagedIterable<>(listAsync(top));
    }

    /**
     * The List operation gets information about the managed HSM Pools associated with the subscription.
     * 
     * @param top Maximum number of results to return.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of a ManagedHsm list operation as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ManagedHsmInner> list(Integer top, Context context) {
        return new PagedIterable<>(listAsync(top, context));
    }

    /**
     * Gets the specified deleted managed HSM.
     * 
     * @param name The name of the deleted managed HSM.
     * @param location The name of the Azure region.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified deleted managed HSM along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DeletedManagedHsmInner>> getDeletedWithResponseAsync(String name, String location) {
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error(new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getDeleted(this.client.getEndpoint(), this.client.getApiVersion(),
                this.client.getSubscriptionId(), location, name, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the specified deleted managed HSM.
     * 
     * @param name The name of the deleted managed HSM.
     * @param location The name of the Azure region.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified deleted managed HSM along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<DeletedManagedHsmInner>> getDeletedWithResponseAsync(String name, String location,
        Context context) {
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error(new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getDeleted(this.client.getEndpoint(), this.client.getApiVersion(),
            this.client.getSubscriptionId(), location, name, accept, context);
    }

    /**
     * Gets the specified deleted managed HSM.
     * 
     * @param name The name of the deleted managed HSM.
     * @param location The name of the Azure region.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified deleted managed HSM on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DeletedManagedHsmInner> getDeletedAsync(String name, String location) {
        return getDeletedWithResponseAsync(name, location).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the specified deleted managed HSM.
     * 
     * @param name The name of the deleted managed HSM.
     * @param location The name of the Azure region.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified deleted managed HSM along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DeletedManagedHsmInner> getDeletedWithResponse(String name, String location, Context context) {
        return getDeletedWithResponseAsync(name, location, context).block();
    }

    /**
     * Gets the specified deleted managed HSM.
     * 
     * @param name The name of the deleted managed HSM.
     * @param location The name of the Azure region.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified deleted managed HSM.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DeletedManagedHsmInner getDeleted(String name, String location) {
        return getDeletedWithResponse(name, location, Context.NONE).getValue();
    }

    /**
     * Permanently deletes the specified managed HSM.
     * 
     * @param name The name of the deleted managed HSM.
     * @param location The name of the Azure region.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> purgeDeletedWithResponseAsync(String name, String location) {
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error(new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.purgeDeleted(this.client.getEndpoint(), this.client.getApiVersion(),
                this.client.getSubscriptionId(), location, name, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Permanently deletes the specified managed HSM.
     * 
     * @param name The name of the deleted managed HSM.
     * @param location The name of the Azure region.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> purgeDeletedWithResponseAsync(String name, String location,
        Context context) {
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error(new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service.purgeDeleted(this.client.getEndpoint(), this.client.getApiVersion(),
            this.client.getSubscriptionId(), location, name, context);
    }

    /**
     * Permanently deletes the specified managed HSM.
     * 
     * @param name The name of the deleted managed HSM.
     * @param location The name of the Azure region.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginPurgeDeletedAsync(String name, String location) {
        Mono<Response<Flux<ByteBuffer>>> mono = purgeDeletedWithResponseAsync(name, location);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            this.client.getContext());
    }

    /**
     * Permanently deletes the specified managed HSM.
     * 
     * @param name The name of the deleted managed HSM.
     * @param location The name of the Azure region.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginPurgeDeletedAsync(String name, String location, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = purgeDeletedWithResponseAsync(name, location, context);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            context);
    }

    /**
     * Permanently deletes the specified managed HSM.
     * 
     * @param name The name of the deleted managed HSM.
     * @param location The name of the Azure region.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginPurgeDeleted(String name, String location) {
        return this.beginPurgeDeletedAsync(name, location).getSyncPoller();
    }

    /**
     * Permanently deletes the specified managed HSM.
     * 
     * @param name The name of the deleted managed HSM.
     * @param location The name of the Azure region.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginPurgeDeleted(String name, String location, Context context) {
        return this.beginPurgeDeletedAsync(name, location, context).getSyncPoller();
    }

    /**
     * Permanently deletes the specified managed HSM.
     * 
     * @param name The name of the deleted managed HSM.
     * @param location The name of the Azure region.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> purgeDeletedAsync(String name, String location) {
        return beginPurgeDeletedAsync(name, location).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Permanently deletes the specified managed HSM.
     * 
     * @param name The name of the deleted managed HSM.
     * @param location The name of the Azure region.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> purgeDeletedAsync(String name, String location, Context context) {
        return beginPurgeDeletedAsync(name, location, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Permanently deletes the specified managed HSM.
     * 
     * @param name The name of the deleted managed HSM.
     * @param location The name of the Azure region.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void purgeDeleted(String name, String location) {
        purgeDeletedAsync(name, location).block();
    }

    /**
     * Permanently deletes the specified managed HSM.
     * 
     * @param name The name of the deleted managed HSM.
     * @param location The name of the Azure region.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void purgeDeleted(String name, String location, Context context) {
        purgeDeletedAsync(name, location, context).block();
    }

    /**
     * The List operation gets information about the deleted managed HSMs associated with the subscription.
     * 
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of a DeletedManagedHsm list operation along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DeletedManagedHsmInner>> listDeletedSinglePageAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listDeleted(this.client.getEndpoint(), this.client.getApiVersion(),
                this.client.getSubscriptionId(), accept, context))
            .<PagedResponse<DeletedManagedHsmInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * The List operation gets information about the deleted managed HSMs associated with the subscription.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of a DeletedManagedHsm list operation along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DeletedManagedHsmInner>> listDeletedSinglePageAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listDeleted(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(),
                accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * The List operation gets information about the deleted managed HSMs associated with the subscription.
     * 
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of a DeletedManagedHsm list operation as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<DeletedManagedHsmInner> listDeletedAsync() {
        return new PagedFlux<>(() -> listDeletedSinglePageAsync(),
            nextLink -> listDeletedNextSinglePageAsync(nextLink));
    }

    /**
     * The List operation gets information about the deleted managed HSMs associated with the subscription.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of a DeletedManagedHsm list operation as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<DeletedManagedHsmInner> listDeletedAsync(Context context) {
        return new PagedFlux<>(() -> listDeletedSinglePageAsync(context),
            nextLink -> listDeletedNextSinglePageAsync(nextLink, context));
    }

    /**
     * The List operation gets information about the deleted managed HSMs associated with the subscription.
     * 
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of a DeletedManagedHsm list operation as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DeletedManagedHsmInner> listDeleted() {
        return new PagedIterable<>(listDeletedAsync());
    }

    /**
     * The List operation gets information about the deleted managed HSMs associated with the subscription.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of a DeletedManagedHsm list operation as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DeletedManagedHsmInner> listDeleted(Context context) {
        return new PagedIterable<>(listDeletedAsync(context));
    }

    /**
     * Checks that the managed hsm name is valid and is not already in use.
     * 
     * @param mhsmName The request body.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the CheckMhsmNameAvailability operation response along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<CheckMhsmNameAvailabilityResultInner>>
        checkMhsmNameAvailabilityWithResponseAsync(CheckMhsmNameAvailabilityParameters mhsmName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (mhsmName == null) {
            return Mono.error(new IllegalArgumentException("Parameter mhsmName is required and cannot be null."));
        } else {
            mhsmName.validate();
        }
        final String contentType = "application/json";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.checkMhsmNameAvailability(this.client.getEndpoint(),
                this.client.getApiVersion(), this.client.getSubscriptionId(), contentType, accept, mhsmName, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Checks that the managed hsm name is valid and is not already in use.
     * 
     * @param mhsmName The request body.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the CheckMhsmNameAvailability operation response along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<CheckMhsmNameAvailabilityResultInner>>
        checkMhsmNameAvailabilityWithResponseAsync(CheckMhsmNameAvailabilityParameters mhsmName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (mhsmName == null) {
            return Mono.error(new IllegalArgumentException("Parameter mhsmName is required and cannot be null."));
        } else {
            mhsmName.validate();
        }
        final String contentType = "application/json";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.checkMhsmNameAvailability(this.client.getEndpoint(), this.client.getApiVersion(),
            this.client.getSubscriptionId(), contentType, accept, mhsmName, context);
    }

    /**
     * Checks that the managed hsm name is valid and is not already in use.
     * 
     * @param mhsmName The request body.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the CheckMhsmNameAvailability operation response on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CheckMhsmNameAvailabilityResultInner>
        checkMhsmNameAvailabilityAsync(CheckMhsmNameAvailabilityParameters mhsmName) {
        return checkMhsmNameAvailabilityWithResponseAsync(mhsmName).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Checks that the managed hsm name is valid and is not already in use.
     * 
     * @param mhsmName The request body.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the CheckMhsmNameAvailability operation response along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<CheckMhsmNameAvailabilityResultInner>
        checkMhsmNameAvailabilityWithResponse(CheckMhsmNameAvailabilityParameters mhsmName, Context context) {
        return checkMhsmNameAvailabilityWithResponseAsync(mhsmName, context).block();
    }

    /**
     * Checks that the managed hsm name is valid and is not already in use.
     * 
     * @param mhsmName The request body.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the CheckMhsmNameAvailability operation response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public CheckMhsmNameAvailabilityResultInner
        checkMhsmNameAvailability(CheckMhsmNameAvailabilityParameters mhsmName) {
        return checkMhsmNameAvailabilityWithResponse(mhsmName, Context.NONE).getValue();
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of a ManagedHsm list operation along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ManagedHsmInner>> listByResourceGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.listByResourceGroupNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<ManagedHsmInner>>map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(),
                res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of a ManagedHsm list operation along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ManagedHsmInner>> listByResourceGroupNextSinglePageAsync(String nextLink,
        Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listByResourceGroupNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of a ManagedHsm list operation along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ManagedHsmInner>> listBySubscriptionNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.listBySubscriptionNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<ManagedHsmInner>>map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(),
                res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of a ManagedHsm list operation along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ManagedHsmInner>> listBySubscriptionNextSinglePageAsync(String nextLink,
        Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listBySubscriptionNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of a DeletedManagedHsm list operation along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DeletedManagedHsmInner>> listDeletedNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listDeletedNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<DeletedManagedHsmInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of a DeletedManagedHsm list operation along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DeletedManagedHsmInner>> listDeletedNextSinglePageAsync(String nextLink,
        Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listDeletedNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }
}
