// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.resourcemanager.keyvault.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.keyvault.models.VaultProperties;
import java.io.IOException;
import java.util.Map;

/**
 * Resource information with extended details.
 */
@Fluent
public final class VaultInner extends Resource {

    /*
     * Properties of the vault
     */
    private VaultProperties properties;

    /*
     * Azure location of the key vault resource.
     */
    private String location;

    /*
     * Tags assigned to the key vault resource.
     */
    private Map<String, String> tags;

    /*
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    private SystemData systemData;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of VaultInner class.
     */
    public VaultInner() {
    }

    /**
     * Get the properties property: Properties of the vault.
     *
     * @return the properties value.
     */
    public VaultProperties properties() {
        return this.properties;
    }

    /**
     * Set the properties property: Properties of the vault.
     *
     * @param properties the properties value to set.
     * @return the VaultInner object itself.
     */
    public VaultInner withProperties(VaultProperties properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Get the location property: Azure location of the key vault resource.
     *
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Set the location property: Azure location of the key vault resource.
     *
     * @param location the location value to set.
     * @return the VaultInner object itself.
     */
    public VaultInner withLocation(String location) {
        this.location = location;
        return this;
    }

    /**
     * Get the tags property: Tags assigned to the key vault resource.
     *
     * @return the tags value.
     */
    public Map<String, String> tags() {
        return this.tags;
    }

    /**
     * Set the tags property: Tags assigned to the key vault resource.
     *
     * @param tags the tags value to set.
     * @return the VaultInner object itself.
     */
    public VaultInner withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the systemData property: Azure Resource Manager metadata containing createdBy and modifiedBy information.
     *
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the type property: The type of the resource.
     *
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     *
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     *
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (properties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property properties in model VaultInner"));
        } else {
            properties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(VaultInner.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.properties);
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VaultInner from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of VaultInner if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the VaultInner.
     */
    public static VaultInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VaultInner deserializedVaultInner = new VaultInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedVaultInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedVaultInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedVaultInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedVaultInner.properties = VaultProperties.fromJson(reader);
                } else if ("location".equals(fieldName)) {
                    deserializedVaultInner.location = reader.getString();
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedVaultInner.tags = tags;
                } else if ("systemData".equals(fieldName)) {
                    deserializedVaultInner.systemData = SystemData.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedVaultInner;
        });
    }
}
