// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.resourcemanager.keyvault.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.keyvault.models.SecretProperties;
import java.io.IOException;
import java.util.Map;

/**
 * Resource information with extended details.
 */
@Immutable
public final class SecretInner extends Resource {

    /*
     * Properties of the secret
     */
    private SecretProperties properties;

    /*
     * Azure location of the key vault resource.
     */
    private String location;

    /*
     * Tags assigned to the key vault resource.
     */
    private Map<String, String> tags;

    /*
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    private SystemData systemData;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of SecretInner class.
     */
    private SecretInner() {
    }

    /**
     * Get the properties property: Properties of the secret.
     *
     * @return the properties value.
     */
    public SecretProperties properties() {
        return this.properties;
    }

    /**
     * Get the location property: Azure location of the key vault resource.
     *
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Get the tags property: Tags assigned to the key vault resource.
     *
     * @return the tags value.
     */
    public Map<String, String> tags() {
        return this.tags;
    }

    /**
     * Get the systemData property: Azure Resource Manager metadata containing createdBy and modifiedBy information.
     *
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the type property: The type of the resource.
     *
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     *
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     *
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (properties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property properties in model SecretInner"));
        } else {
            properties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(SecretInner.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.properties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SecretInner from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of SecretInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the SecretInner.
     */
    public static SecretInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SecretInner deserializedSecretInner = new SecretInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedSecretInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedSecretInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedSecretInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedSecretInner.properties = SecretProperties.fromJson(reader);
                } else if ("location".equals(fieldName)) {
                    deserializedSecretInner.location = reader.getString();
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedSecretInner.tags = tags;
                } else if ("systemData".equals(fieldName)) {
                    deserializedSecretInner.systemData = SystemData.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedSecretInner;
        });
    }
}
