// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.resourcemanager.keyvault.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.keyvault.models.GeoReplicationRegionProvisioningState;
import java.io.IOException;

/**
 * A region that this managed HSM Pool has been extended to.
 */
@Fluent
public final class MhsmGeoReplicatedRegionInner implements JsonSerializable<MhsmGeoReplicatedRegionInner> {
    /*
     * Name of the geo replicated region.
     */
    private String name;

    /*
     * Provisioning state of the geo replicated region.
     */
    private GeoReplicationRegionProvisioningState provisioningState;

    /*
     * A boolean value that indicates whether the region is the primary region or a secondary region.
     */
    private Boolean isPrimary;

    /**
     * Creates an instance of MhsmGeoReplicatedRegionInner class.
     */
    public MhsmGeoReplicatedRegionInner() {
    }

    /**
     * Get the name property: Name of the geo replicated region.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of the geo replicated region.
     * 
     * @param name the name value to set.
     * @return the MhsmGeoReplicatedRegionInner object itself.
     */
    public MhsmGeoReplicatedRegionInner withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the provisioningState property: Provisioning state of the geo replicated region.
     * 
     * @return the provisioningState value.
     */
    public GeoReplicationRegionProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the isPrimary property: A boolean value that indicates whether the region is the primary region or a
     * secondary region.
     * 
     * @return the isPrimary value.
     */
    public Boolean isPrimary() {
        return this.isPrimary;
    }

    /**
     * Set the isPrimary property: A boolean value that indicates whether the region is the primary region or a
     * secondary region.
     * 
     * @param isPrimary the isPrimary value to set.
     * @return the MhsmGeoReplicatedRegionInner object itself.
     */
    public MhsmGeoReplicatedRegionInner withIsPrimary(Boolean isPrimary) {
        this.isPrimary = isPrimary;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeBooleanField("isPrimary", this.isPrimary);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MhsmGeoReplicatedRegionInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MhsmGeoReplicatedRegionInner if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MhsmGeoReplicatedRegionInner.
     */
    public static MhsmGeoReplicatedRegionInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MhsmGeoReplicatedRegionInner deserializedMhsmGeoReplicatedRegionInner = new MhsmGeoReplicatedRegionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedMhsmGeoReplicatedRegionInner.name = reader.getString();
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedMhsmGeoReplicatedRegionInner.provisioningState
                        = GeoReplicationRegionProvisioningState.fromString(reader.getString());
                } else if ("isPrimary".equals(fieldName)) {
                    deserializedMhsmGeoReplicatedRegionInner.isPrimary = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMhsmGeoReplicatedRegionInner;
        });
    }
}
