// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.resourcemanager.keyvault.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.keyvault.models.ManagedHsmProperties;
import com.azure.resourcemanager.keyvault.models.ManagedHsmSku;
import com.azure.resourcemanager.keyvault.models.ManagedServiceIdentity;
import java.io.IOException;
import java.util.Map;

/**
 * Resource information with extended details.
 */
@Fluent
public final class ManagedHsmInner extends Resource {

    /*
     * Properties of the managed HSM
     */
    private ManagedHsmProperties properties;

    /*
     * Resource tags.
     */
    private Map<String, String> tags;

    /*
     * The geo-location where the resource lives
     */
    private String location;

    /*
     * SKU details
     */
    private ManagedHsmSku sku;

    /*
     * Managed service identity
     */
    private ManagedServiceIdentity identity;

    /*
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    private SystemData systemData;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of ManagedHsmInner class.
     */
    public ManagedHsmInner() {
    }

    /**
     * Get the properties property: Properties of the managed HSM.
     *
     * @return the properties value.
     */
    public ManagedHsmProperties properties() {
        return this.properties;
    }

    /**
     * Set the properties property: Properties of the managed HSM.
     *
     * @param properties the properties value to set.
     * @return the ManagedHsmInner object itself.
     */
    public ManagedHsmInner withProperties(ManagedHsmProperties properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Get the tags property: Resource tags.
     *
     * @return the tags value.
     */
    public Map<String, String> tags() {
        return this.tags;
    }

    /**
     * Set the tags property: Resource tags.
     *
     * @param tags the tags value to set.
     * @return the ManagedHsmInner object itself.
     */
    public ManagedHsmInner withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the location property: The geo-location where the resource lives.
     *
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Set the location property: The geo-location where the resource lives.
     *
     * @param location the location value to set.
     * @return the ManagedHsmInner object itself.
     */
    public ManagedHsmInner withLocation(String location) {
        this.location = location;
        return this;
    }

    /**
     * Get the sku property: SKU details.
     *
     * @return the sku value.
     */
    public ManagedHsmSku sku() {
        return this.sku;
    }

    /**
     * Set the sku property: SKU details.
     *
     * @param sku the sku value to set.
     * @return the ManagedHsmInner object itself.
     */
    public ManagedHsmInner withSku(ManagedHsmSku sku) {
        this.sku = sku;
        return this;
    }

    /**
     * Get the identity property: Managed service identity.
     *
     * @return the identity value.
     */
    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    /**
     * Set the identity property: Managed service identity.
     *
     * @param identity the identity value to set.
     * @return the ManagedHsmInner object itself.
     */
    public ManagedHsmInner withIdentity(ManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    /**
     * Get the systemData property: Azure Resource Manager metadata containing createdBy and modifiedBy information.
     *
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the type property: The type of the resource.
     *
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     *
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     *
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (properties() != null) {
            properties().validate();
        }
        if (sku() != null) {
            sku().validate();
        }
        if (identity() != null) {
            identity().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.properties);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeJsonField("sku", this.sku);
        jsonWriter.writeJsonField("identity", this.identity);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedHsmInner from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedHsmInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ManagedHsmInner.
     */
    public static ManagedHsmInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedHsmInner deserializedManagedHsmInner = new ManagedHsmInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedManagedHsmInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedManagedHsmInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedManagedHsmInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedManagedHsmInner.properties = ManagedHsmProperties.fromJson(reader);
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedManagedHsmInner.tags = tags;
                } else if ("location".equals(fieldName)) {
                    deserializedManagedHsmInner.location = reader.getString();
                } else if ("sku".equals(fieldName)) {
                    deserializedManagedHsmInner.sku = ManagedHsmSku.fromJson(reader);
                } else if ("identity".equals(fieldName)) {
                    deserializedManagedHsmInner.identity = ManagedServiceIdentity.fromJson(reader);
                } else if ("systemData".equals(fieldName)) {
                    deserializedManagedHsmInner.systemData = SystemData.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedManagedHsmInner;
        });
    }
}
