// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.resourcemanager.keyvault.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.resourcemanager.keyvault.fluent.models.MhsmGeoReplicatedRegionInner;

/**
 * An instance of this class provides access to all the operations defined in MhsmRegionsClient.
 */
public interface MhsmRegionsClient {
    /**
     * The List operation gets information about the regions associated with the managed HSM Pool.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the managed HSM Pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.keyvault.models.ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of regions associated with a managed HSM Pools as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<MhsmGeoReplicatedRegionInner> listByResourceAsync(String resourceGroupName, String name);

    /**
     * The List operation gets information about the regions associated with the managed HSM Pool.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the managed HSM Pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.keyvault.models.ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of regions associated with a managed HSM Pools as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<MhsmGeoReplicatedRegionInner> listByResource(String resourceGroupName, String name);

    /**
     * The List operation gets information about the regions associated with the managed HSM Pool.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the managed HSM Pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.keyvault.models.ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of regions associated with a managed HSM Pools as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<MhsmGeoReplicatedRegionInner> listByResource(String resourceGroupName, String name, Context context);
}
