// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.resourcemanager.keyvault.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.keyvault.fluent.models.CheckMhsmNameAvailabilityResultInner;
import com.azure.resourcemanager.keyvault.fluent.models.DeletedManagedHsmInner;
import com.azure.resourcemanager.keyvault.fluent.models.ManagedHsmInner;
import com.azure.resourcemanager.keyvault.models.CheckMhsmNameAvailabilityParameters;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsGet;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in ManagedHsmsClient.
 */
public interface ManagedHsmsClient
    extends InnerSupportsGet<ManagedHsmInner>, InnerSupportsListing<ManagedHsmInner>, InnerSupportsDelete<Void> {
    /**
     * Gets the specified managed HSM Pool.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the managed HSM Pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.keyvault.models.ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified managed HSM Pool along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ManagedHsmInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String name);

    /**
     * Gets the specified managed HSM Pool.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the managed HSM Pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.keyvault.models.ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified managed HSM Pool on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ManagedHsmInner> getByResourceGroupAsync(String resourceGroupName, String name);

    /**
     * Gets the specified managed HSM Pool.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the managed HSM Pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.keyvault.models.ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified managed HSM Pool along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ManagedHsmInner> getByResourceGroupWithResponse(String resourceGroupName, String name, Context context);

    /**
     * Gets the specified managed HSM Pool.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the managed HSM Pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.keyvault.models.ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified managed HSM Pool.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ManagedHsmInner getByResourceGroup(String resourceGroupName, String name);

    /**
     * Create or update a managed HSM Pool in the specified subscription.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the managed HSM Pool.
     * @param parameters Parameters to create or update the managed HSM Pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.keyvault.models.ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return resource information with extended details along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String name,
        ManagedHsmInner parameters);

    /**
     * Create or update a managed HSM Pool in the specified subscription.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the managed HSM Pool.
     * @param parameters Parameters to create or update the managed HSM Pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.keyvault.models.ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of resource information with extended details.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<ManagedHsmInner>, ManagedHsmInner> beginCreateOrUpdateAsync(String resourceGroupName,
        String name, ManagedHsmInner parameters);

    /**
     * Create or update a managed HSM Pool in the specified subscription.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the managed HSM Pool.
     * @param parameters Parameters to create or update the managed HSM Pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.keyvault.models.ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of resource information with extended details.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<ManagedHsmInner>, ManagedHsmInner> beginCreateOrUpdate(String resourceGroupName, String name,
        ManagedHsmInner parameters);

    /**
     * Create or update a managed HSM Pool in the specified subscription.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the managed HSM Pool.
     * @param parameters Parameters to create or update the managed HSM Pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.keyvault.models.ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of resource information with extended details.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<ManagedHsmInner>, ManagedHsmInner> beginCreateOrUpdate(String resourceGroupName, String name,
        ManagedHsmInner parameters, Context context);

    /**
     * Create or update a managed HSM Pool in the specified subscription.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the managed HSM Pool.
     * @param parameters Parameters to create or update the managed HSM Pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.keyvault.models.ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return resource information with extended details on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ManagedHsmInner> createOrUpdateAsync(String resourceGroupName, String name, ManagedHsmInner parameters);

    /**
     * Create or update a managed HSM Pool in the specified subscription.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the managed HSM Pool.
     * @param parameters Parameters to create or update the managed HSM Pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.keyvault.models.ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return resource information with extended details.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ManagedHsmInner createOrUpdate(String resourceGroupName, String name, ManagedHsmInner parameters);

    /**
     * Create or update a managed HSM Pool in the specified subscription.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the managed HSM Pool.
     * @param parameters Parameters to create or update the managed HSM Pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.keyvault.models.ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return resource information with extended details.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ManagedHsmInner createOrUpdate(String resourceGroupName, String name, ManagedHsmInner parameters, Context context);

    /**
     * Update a managed HSM Pool in the specified subscription.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the managed HSM Pool.
     * @param parameters Parameters to patch the managed HSM Pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.keyvault.models.ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return resource information with extended details along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String name,
        ManagedHsmInner parameters);

    /**
     * Update a managed HSM Pool in the specified subscription.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the managed HSM Pool.
     * @param parameters Parameters to patch the managed HSM Pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.keyvault.models.ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of resource information with extended details.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<ManagedHsmInner>, ManagedHsmInner> beginUpdateAsync(String resourceGroupName, String name,
        ManagedHsmInner parameters);

    /**
     * Update a managed HSM Pool in the specified subscription.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the managed HSM Pool.
     * @param parameters Parameters to patch the managed HSM Pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.keyvault.models.ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of resource information with extended details.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<ManagedHsmInner>, ManagedHsmInner> beginUpdate(String resourceGroupName, String name,
        ManagedHsmInner parameters);

    /**
     * Update a managed HSM Pool in the specified subscription.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the managed HSM Pool.
     * @param parameters Parameters to patch the managed HSM Pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.keyvault.models.ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of resource information with extended details.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<ManagedHsmInner>, ManagedHsmInner> beginUpdate(String resourceGroupName, String name,
        ManagedHsmInner parameters, Context context);

    /**
     * Update a managed HSM Pool in the specified subscription.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the managed HSM Pool.
     * @param parameters Parameters to patch the managed HSM Pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.keyvault.models.ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return resource information with extended details on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ManagedHsmInner> updateAsync(String resourceGroupName, String name, ManagedHsmInner parameters);

    /**
     * Update a managed HSM Pool in the specified subscription.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the managed HSM Pool.
     * @param parameters Parameters to patch the managed HSM Pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.keyvault.models.ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return resource information with extended details.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ManagedHsmInner update(String resourceGroupName, String name, ManagedHsmInner parameters);

    /**
     * Update a managed HSM Pool in the specified subscription.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the managed HSM Pool.
     * @param parameters Parameters to patch the managed HSM Pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.keyvault.models.ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return resource information with extended details.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ManagedHsmInner update(String resourceGroupName, String name, ManagedHsmInner parameters, Context context);

    /**
     * Deletes the specified managed HSM Pool.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the managed HSM Pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.keyvault.models.ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String name);

    /**
     * Deletes the specified managed HSM Pool.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the managed HSM Pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.keyvault.models.ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String name);

    /**
     * Deletes the specified managed HSM Pool.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the managed HSM Pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.keyvault.models.ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String name);

    /**
     * Deletes the specified managed HSM Pool.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the managed HSM Pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.keyvault.models.ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String name, Context context);

    /**
     * Deletes the specified managed HSM Pool.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the managed HSM Pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.keyvault.models.ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(String resourceGroupName, String name);

    /**
     * Deletes the specified managed HSM Pool.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the managed HSM Pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.keyvault.models.ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String name);

    /**
     * Deletes the specified managed HSM Pool.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the managed HSM Pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.keyvault.models.ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String name, Context context);

    /**
     * The List operation gets information about the managed HSM Pools associated with the subscription and within the
     * specified resource group.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param top Maximum number of results to return.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.keyvault.models.ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of a ManagedHsm list operation as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<ManagedHsmInner> listByResourceGroupAsync(String resourceGroupName, Integer top);

    /**
     * The List operation gets information about the managed HSM Pools associated with the subscription and within the
     * specified resource group.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.keyvault.models.ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of a ManagedHsm list operation as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<ManagedHsmInner> listByResourceGroupAsync(String resourceGroupName);

    /**
     * The List operation gets information about the managed HSM Pools associated with the subscription and within the
     * specified resource group.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.keyvault.models.ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of a ManagedHsm list operation as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ManagedHsmInner> listByResourceGroup(String resourceGroupName);

    /**
     * The List operation gets information about the managed HSM Pools associated with the subscription and within the
     * specified resource group.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param top Maximum number of results to return.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.keyvault.models.ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of a ManagedHsm list operation as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ManagedHsmInner> listByResourceGroup(String resourceGroupName, Integer top, Context context);

    /**
     * The List operation gets information about the managed HSM Pools associated with the subscription.
     * 
     * @param top Maximum number of results to return.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.keyvault.models.ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of a ManagedHsm list operation as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<ManagedHsmInner> listAsync(Integer top);

    /**
     * The List operation gets information about the managed HSM Pools associated with the subscription.
     * 
     * @throws com.azure.resourcemanager.keyvault.models.ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of a ManagedHsm list operation as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<ManagedHsmInner> listAsync();

    /**
     * The List operation gets information about the managed HSM Pools associated with the subscription.
     * 
     * @throws com.azure.resourcemanager.keyvault.models.ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of a ManagedHsm list operation as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ManagedHsmInner> list();

    /**
     * The List operation gets information about the managed HSM Pools associated with the subscription.
     * 
     * @param top Maximum number of results to return.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.keyvault.models.ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of a ManagedHsm list operation as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ManagedHsmInner> list(Integer top, Context context);

    /**
     * Gets the specified deleted managed HSM.
     * 
     * @param name The name of the deleted managed HSM.
     * @param location The name of the Azure region.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.keyvault.models.ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified deleted managed HSM along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<DeletedManagedHsmInner>> getDeletedWithResponseAsync(String name, String location);

    /**
     * Gets the specified deleted managed HSM.
     * 
     * @param name The name of the deleted managed HSM.
     * @param location The name of the Azure region.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.keyvault.models.ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified deleted managed HSM on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<DeletedManagedHsmInner> getDeletedAsync(String name, String location);

    /**
     * Gets the specified deleted managed HSM.
     * 
     * @param name The name of the deleted managed HSM.
     * @param location The name of the Azure region.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.keyvault.models.ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified deleted managed HSM along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<DeletedManagedHsmInner> getDeletedWithResponse(String name, String location, Context context);

    /**
     * Gets the specified deleted managed HSM.
     * 
     * @param name The name of the deleted managed HSM.
     * @param location The name of the Azure region.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.keyvault.models.ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified deleted managed HSM.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DeletedManagedHsmInner getDeleted(String name, String location);

    /**
     * Permanently deletes the specified managed HSM.
     * 
     * @param name The name of the deleted managed HSM.
     * @param location The name of the Azure region.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.keyvault.models.ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> purgeDeletedWithResponseAsync(String name, String location);

    /**
     * Permanently deletes the specified managed HSM.
     * 
     * @param name The name of the deleted managed HSM.
     * @param location The name of the Azure region.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.keyvault.models.ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginPurgeDeletedAsync(String name, String location);

    /**
     * Permanently deletes the specified managed HSM.
     * 
     * @param name The name of the deleted managed HSM.
     * @param location The name of the Azure region.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.keyvault.models.ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginPurgeDeleted(String name, String location);

    /**
     * Permanently deletes the specified managed HSM.
     * 
     * @param name The name of the deleted managed HSM.
     * @param location The name of the Azure region.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.keyvault.models.ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginPurgeDeleted(String name, String location, Context context);

    /**
     * Permanently deletes the specified managed HSM.
     * 
     * @param name The name of the deleted managed HSM.
     * @param location The name of the Azure region.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.keyvault.models.ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> purgeDeletedAsync(String name, String location);

    /**
     * Permanently deletes the specified managed HSM.
     * 
     * @param name The name of the deleted managed HSM.
     * @param location The name of the Azure region.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.keyvault.models.ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void purgeDeleted(String name, String location);

    /**
     * Permanently deletes the specified managed HSM.
     * 
     * @param name The name of the deleted managed HSM.
     * @param location The name of the Azure region.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.keyvault.models.ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void purgeDeleted(String name, String location, Context context);

    /**
     * The List operation gets information about the deleted managed HSMs associated with the subscription.
     * 
     * @throws com.azure.resourcemanager.keyvault.models.ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of a DeletedManagedHsm list operation as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<DeletedManagedHsmInner> listDeletedAsync();

    /**
     * The List operation gets information about the deleted managed HSMs associated with the subscription.
     * 
     * @throws com.azure.resourcemanager.keyvault.models.ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of a DeletedManagedHsm list operation as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<DeletedManagedHsmInner> listDeleted();

    /**
     * The List operation gets information about the deleted managed HSMs associated with the subscription.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.keyvault.models.ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of a DeletedManagedHsm list operation as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<DeletedManagedHsmInner> listDeleted(Context context);

    /**
     * Checks that the managed hsm name is valid and is not already in use.
     * 
     * @param mhsmName The request body.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the CheckMhsmNameAvailability operation response along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<CheckMhsmNameAvailabilityResultInner>>
        checkMhsmNameAvailabilityWithResponseAsync(CheckMhsmNameAvailabilityParameters mhsmName);

    /**
     * Checks that the managed hsm name is valid and is not already in use.
     * 
     * @param mhsmName The request body.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the CheckMhsmNameAvailability operation response on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<CheckMhsmNameAvailabilityResultInner>
        checkMhsmNameAvailabilityAsync(CheckMhsmNameAvailabilityParameters mhsmName);

    /**
     * Checks that the managed hsm name is valid and is not already in use.
     * 
     * @param mhsmName The request body.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the CheckMhsmNameAvailability operation response along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<CheckMhsmNameAvailabilityResultInner>
        checkMhsmNameAvailabilityWithResponse(CheckMhsmNameAvailabilityParameters mhsmName, Context context);

    /**
     * Checks that the managed hsm name is valid and is not already in use.
     * 
     * @param mhsmName The request body.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the CheckMhsmNameAvailability operation response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    CheckMhsmNameAvailabilityResultInner checkMhsmNameAvailability(CheckMhsmNameAvailabilityParameters mhsmName);
}
