// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.resourcemanager.keyvault.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.keyvault.fluent.models.KeyInner;
import com.azure.resourcemanager.keyvault.models.KeyCreateParameters;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in KeysClient.
 */
public interface KeysClient {
    /**
     * Gets the current version of the specified key from the specified key vault.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vaultName The name of the vault which contains the key to be retrieved.
     * @param keyName The name of the key to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the current version of the specified key from the specified key vault along with {@link Response} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<KeyInner>> getWithResponseAsync(String resourceGroupName, String vaultName, String keyName);

    /**
     * Gets the current version of the specified key from the specified key vault.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vaultName The name of the vault which contains the key to be retrieved.
     * @param keyName The name of the key to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the current version of the specified key from the specified key vault on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<KeyInner> getAsync(String resourceGroupName, String vaultName, String keyName);

    /**
     * Gets the current version of the specified key from the specified key vault.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vaultName The name of the vault which contains the key to be retrieved.
     * @param keyName The name of the key to be retrieved.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the current version of the specified key from the specified key vault along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<KeyInner> getWithResponse(String resourceGroupName, String vaultName, String keyName, Context context);

    /**
     * Gets the current version of the specified key from the specified key vault.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vaultName The name of the vault which contains the key to be retrieved.
     * @param keyName The name of the key to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the current version of the specified key from the specified key vault.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    KeyInner get(String resourceGroupName, String vaultName, String keyName);

    /**
     * Creates the first version of a new key if it does not exist. If it already exists, then the existing key is
     * returned without any write operations being performed. This API does not create subsequent versions, and does not
     * update existing keys.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vaultName The name of the vault which contains the key to be retrieved.
     * @param keyName The name of the key to be retrieved.
     * @param parameters The parameters used to create the specified key.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<KeyInner>> createIfNotExistWithResponseAsync(String resourceGroupName, String vaultName,
        String keyName, KeyCreateParameters parameters);

    /**
     * Creates the first version of a new key if it does not exist. If it already exists, then the existing key is
     * returned without any write operations being performed. This API does not create subsequent versions, and does not
     * update existing keys.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vaultName The name of the vault which contains the key to be retrieved.
     * @param keyName The name of the key to be retrieved.
     * @param parameters The parameters used to create the specified key.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<KeyInner> createIfNotExistAsync(String resourceGroupName, String vaultName, String keyName,
        KeyCreateParameters parameters);

    /**
     * Creates the first version of a new key if it does not exist. If it already exists, then the existing key is
     * returned without any write operations being performed. This API does not create subsequent versions, and does not
     * update existing keys.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vaultName The name of the vault which contains the key to be retrieved.
     * @param keyName The name of the key to be retrieved.
     * @param parameters The parameters used to create the specified key.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<KeyInner> createIfNotExistWithResponse(String resourceGroupName, String vaultName, String keyName,
        KeyCreateParameters parameters, Context context);

    /**
     * Creates the first version of a new key if it does not exist. If it already exists, then the existing key is
     * returned without any write operations being performed. This API does not create subsequent versions, and does not
     * update existing keys.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vaultName The name of the vault which contains the key to be retrieved.
     * @param keyName The name of the key to be retrieved.
     * @param parameters The parameters used to create the specified key.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    KeyInner createIfNotExist(String resourceGroupName, String vaultName, String keyName,
        KeyCreateParameters parameters);

    /**
     * Lists the keys in the specified key vault.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vaultName The name of the vault which contains the key to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of a Key list operation as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<KeyInner> listAsync(String resourceGroupName, String vaultName);

    /**
     * Lists the keys in the specified key vault.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vaultName The name of the vault which contains the key to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of a Key list operation as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<KeyInner> list(String resourceGroupName, String vaultName);

    /**
     * Lists the keys in the specified key vault.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vaultName The name of the vault which contains the key to be retrieved.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of a Key list operation as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<KeyInner> list(String resourceGroupName, String vaultName, Context context);

    /**
     * Gets the specified version of the specified key in the specified key vault.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vaultName The name of the vault which contains the key version to be retrieved.
     * @param keyName The name of the key version to be retrieved.
     * @param keyVersion The version of the key to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified version of the specified key in the specified key vault along with {@link Response} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<KeyInner>> getVersionWithResponseAsync(String resourceGroupName, String vaultName, String keyName,
        String keyVersion);

    /**
     * Gets the specified version of the specified key in the specified key vault.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vaultName The name of the vault which contains the key version to be retrieved.
     * @param keyName The name of the key version to be retrieved.
     * @param keyVersion The version of the key to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified version of the specified key in the specified key vault on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<KeyInner> getVersionAsync(String resourceGroupName, String vaultName, String keyName, String keyVersion);

    /**
     * Gets the specified version of the specified key in the specified key vault.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vaultName The name of the vault which contains the key version to be retrieved.
     * @param keyName The name of the key version to be retrieved.
     * @param keyVersion The version of the key to be retrieved.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified version of the specified key in the specified key vault along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<KeyInner> getVersionWithResponse(String resourceGroupName, String vaultName, String keyName,
        String keyVersion, Context context);

    /**
     * Gets the specified version of the specified key in the specified key vault.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vaultName The name of the vault which contains the key version to be retrieved.
     * @param keyName The name of the key version to be retrieved.
     * @param keyVersion The version of the key to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified version of the specified key in the specified key vault.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    KeyInner getVersion(String resourceGroupName, String vaultName, String keyName, String keyVersion);

    /**
     * Lists the keys in the specified key vault.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vaultName The name of the vault which contains the key version to be retrieved.
     * @param keyName The name of the key version to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of a Key list operation as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<KeyInner> listVersionsAsync(String resourceGroupName, String vaultName, String keyName);

    /**
     * Lists the keys in the specified key vault.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vaultName The name of the vault which contains the key version to be retrieved.
     * @param keyName The name of the key version to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of a Key list operation as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<KeyInner> listVersions(String resourceGroupName, String vaultName, String keyName);

    /**
     * Lists the keys in the specified key vault.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vaultName The name of the vault which contains the key version to be retrieved.
     * @param keyName The name of the key version to be retrieved.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of a Key list operation as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<KeyInner> listVersions(String resourceGroupName, String vaultName, String keyName, Context context);
}
