// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.resourcemanager.keyvault.fluent;

import com.azure.core.http.HttpPipeline;
import java.time.Duration;

/**
 * The interface for KeyVaultManagementClient class.
 */
public interface KeyVaultManagementClient {
    /**
     * Gets Service host.
     * 
     * @return the endpoint value.
     */
    String getEndpoint();

    /**
     * Gets Version parameter.
     * 
     * @return the apiVersion value.
     */
    String getApiVersion();

    /**
     * Gets The ID of the target subscription. The value must be an UUID.
     * 
     * @return the subscriptionId value.
     */
    String getSubscriptionId();

    /**
     * Gets The HTTP pipeline to send requests through.
     * 
     * @return the httpPipeline value.
     */
    HttpPipeline getHttpPipeline();

    /**
     * Gets The default poll interval for long-running operation.
     * 
     * @return the defaultPollInterval value.
     */
    Duration getDefaultPollInterval();

    /**
     * Gets the OperationsClient object to access its operations.
     * 
     * @return the OperationsClient object.
     */
    OperationsClient getOperations();

    /**
     * Gets the VaultsClient object to access its operations.
     * 
     * @return the VaultsClient object.
     */
    VaultsClient getVaults();

    /**
     * Gets the PrivateEndpointConnectionsClient object to access its operations.
     * 
     * @return the PrivateEndpointConnectionsClient object.
     */
    PrivateEndpointConnectionsClient getPrivateEndpointConnections();

    /**
     * Gets the ManagedHsmsClient object to access its operations.
     * 
     * @return the ManagedHsmsClient object.
     */
    ManagedHsmsClient getManagedHsms();

    /**
     * Gets the MhsmPrivateEndpointConnectionsClient object to access its operations.
     * 
     * @return the MhsmPrivateEndpointConnectionsClient object.
     */
    MhsmPrivateEndpointConnectionsClient getMhsmPrivateEndpointConnections();

    /**
     * Gets the SecretsClient object to access its operations.
     * 
     * @return the SecretsClient object.
     */
    SecretsClient getSecrets();

    /**
     * Gets the KeysClient object to access its operations.
     * 
     * @return the KeysClient object.
     */
    KeysClient getKeys();

    /**
     * Gets the ManagedHsmKeysClient object to access its operations.
     * 
     * @return the ManagedHsmKeysClient object.
     */
    ManagedHsmKeysClient getManagedHsmKeys();

    /**
     * Gets the PrivateLinkResourcesClient object to access its operations.
     * 
     * @return the PrivateLinkResourcesClient object.
     */
    PrivateLinkResourcesClient getPrivateLinkResources();

    /**
     * Gets the MhsmPrivateLinkResourcesClient object to access its operations.
     * 
     * @return the MhsmPrivateLinkResourcesClient object.
     */
    MhsmPrivateLinkResourcesClient getMhsmPrivateLinkResources();

    /**
     * Gets the MhsmRegionsClient object to access its operations.
     * 
     * @return the MhsmRegionsClient object.
     */
    MhsmRegionsClient getMhsmRegions();
}
