// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.keyvault.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.keyvault.fluent.models.ManagedHsmInner;
import java.io.IOException;
import java.util.List;

/**
 * List of managed HSM Pools.
 */
@Fluent
public final class ManagedHsmListResult implements JsonSerializable<ManagedHsmListResult> {
    /*
     * The list of managed HSM Pools.
     */
    private List<ManagedHsmInner> value;

    /*
     * The URL to get the next set of managed HSM Pools.
     */
    private String nextLink;

    /**
     * Creates an instance of ManagedHsmListResult class.
     */
    public ManagedHsmListResult() {
    }

    /**
     * Get the value property: The list of managed HSM Pools.
     * 
     * @return the value value.
     */
    public List<ManagedHsmInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The list of managed HSM Pools.
     * 
     * @param value the value value to set.
     * @return the ManagedHsmListResult object itself.
     */
    public ManagedHsmListResult withValue(List<ManagedHsmInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URL to get the next set of managed HSM Pools.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The URL to get the next set of managed HSM Pools.
     * 
     * @param nextLink the nextLink value to set.
     * @return the ManagedHsmListResult object itself.
     */
    public ManagedHsmListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedHsmListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedHsmListResult if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ManagedHsmListResult.
     */
    public static ManagedHsmListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedHsmListResult deserializedManagedHsmListResult = new ManagedHsmListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<ManagedHsmInner> value = reader.readArray(reader1 -> ManagedHsmInner.fromJson(reader1));
                    deserializedManagedHsmListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedManagedHsmListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedHsmListResult;
        });
    }
}
