// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.keyvault.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.keyvault.fluent.models.ManagedHsmKeyInner;
import com.azure.resourcemanager.keyvault.models.ManagedHsmKeyCreateParameters;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in ManagedHsmKeysClient.
 */
public interface ManagedHsmKeysClient {
    /**
     * Creates the first version of a new key if it does not exist. If it already exists, then the existing key is
     * returned without any write operations being performed. This API does not create subsequent versions, and does not
     * update existing keys.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the Managed HSM Pool within the specified resource group.
     * @param keyName The name of the key to be created. The value you provide may be copied globally for the purpose of
     * running the service. The value provided should not include personally identifiable or sensitive information.
     * @param parameters The parameters used to create the specified key.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ManagedHsmKeyInner>> createIfNotExistWithResponseAsync(String resourceGroupName, String name,
        String keyName, ManagedHsmKeyCreateParameters parameters);

    /**
     * Creates the first version of a new key if it does not exist. If it already exists, then the existing key is
     * returned without any write operations being performed. This API does not create subsequent versions, and does not
     * update existing keys.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the Managed HSM Pool within the specified resource group.
     * @param keyName The name of the key to be created. The value you provide may be copied globally for the purpose of
     * running the service. The value provided should not include personally identifiable or sensitive information.
     * @param parameters The parameters used to create the specified key.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ManagedHsmKeyInner> createIfNotExistAsync(String resourceGroupName, String name, String keyName,
        ManagedHsmKeyCreateParameters parameters);

    /**
     * Creates the first version of a new key if it does not exist. If it already exists, then the existing key is
     * returned without any write operations being performed. This API does not create subsequent versions, and does not
     * update existing keys.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the Managed HSM Pool within the specified resource group.
     * @param keyName The name of the key to be created. The value you provide may be copied globally for the purpose of
     * running the service. The value provided should not include personally identifiable or sensitive information.
     * @param parameters The parameters used to create the specified key.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ManagedHsmKeyInner> createIfNotExistWithResponse(String resourceGroupName, String name, String keyName,
        ManagedHsmKeyCreateParameters parameters, Context context);

    /**
     * Creates the first version of a new key if it does not exist. If it already exists, then the existing key is
     * returned without any write operations being performed. This API does not create subsequent versions, and does not
     * update existing keys.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the Managed HSM Pool within the specified resource group.
     * @param keyName The name of the key to be created. The value you provide may be copied globally for the purpose of
     * running the service. The value provided should not include personally identifiable or sensitive information.
     * @param parameters The parameters used to create the specified key.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ManagedHsmKeyInner createIfNotExist(String resourceGroupName, String name, String keyName,
        ManagedHsmKeyCreateParameters parameters);

    /**
     * Gets the current version of the specified key from the specified managed HSM.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the Managed HSM Pool within the specified resource group.
     * @param keyName The name of the key to be created. The value you provide may be copied globally for the purpose of
     * running the service. The value provided should not include personally identifiable or sensitive information.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the current version of the specified key from the specified managed HSM along with {@link Response} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ManagedHsmKeyInner>> getWithResponseAsync(String resourceGroupName, String name, String keyName);

    /**
     * Gets the current version of the specified key from the specified managed HSM.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the Managed HSM Pool within the specified resource group.
     * @param keyName The name of the key to be created. The value you provide may be copied globally for the purpose of
     * running the service. The value provided should not include personally identifiable or sensitive information.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the current version of the specified key from the specified managed HSM on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ManagedHsmKeyInner> getAsync(String resourceGroupName, String name, String keyName);

    /**
     * Gets the current version of the specified key from the specified managed HSM.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the Managed HSM Pool within the specified resource group.
     * @param keyName The name of the key to be created. The value you provide may be copied globally for the purpose of
     * running the service. The value provided should not include personally identifiable or sensitive information.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the current version of the specified key from the specified managed HSM along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ManagedHsmKeyInner> getWithResponse(String resourceGroupName, String name, String keyName,
        Context context);

    /**
     * Gets the current version of the specified key from the specified managed HSM.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the Managed HSM Pool within the specified resource group.
     * @param keyName The name of the key to be created. The value you provide may be copied globally for the purpose of
     * running the service. The value provided should not include personally identifiable or sensitive information.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the current version of the specified key from the specified managed HSM.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ManagedHsmKeyInner get(String resourceGroupName, String name, String keyName);

    /**
     * Lists the keys in the specified managed HSM.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the Managed HSM Pool within the specified resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the page of keys as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<ManagedHsmKeyInner> listAsync(String resourceGroupName, String name);

    /**
     * Lists the keys in the specified managed HSM.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the Managed HSM Pool within the specified resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the page of keys as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ManagedHsmKeyInner> list(String resourceGroupName, String name);

    /**
     * Lists the keys in the specified managed HSM.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the Managed HSM Pool within the specified resource group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the page of keys as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ManagedHsmKeyInner> list(String resourceGroupName, String name, Context context);

    /**
     * Gets the specified version of the specified key in the specified managed HSM.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the Managed HSM Pool within the specified resource group.
     * @param keyName The name of the key to be created. The value you provide may be copied globally for the purpose of
     * running the service. The value provided should not include personally identifiable or sensitive information.
     * @param keyVersion The version of the key to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified version of the specified key in the specified managed HSM along with {@link Response} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ManagedHsmKeyInner>> getVersionWithResponseAsync(String resourceGroupName, String name,
        String keyName, String keyVersion);

    /**
     * Gets the specified version of the specified key in the specified managed HSM.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the Managed HSM Pool within the specified resource group.
     * @param keyName The name of the key to be created. The value you provide may be copied globally for the purpose of
     * running the service. The value provided should not include personally identifiable or sensitive information.
     * @param keyVersion The version of the key to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified version of the specified key in the specified managed HSM on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ManagedHsmKeyInner> getVersionAsync(String resourceGroupName, String name, String keyName, String keyVersion);

    /**
     * Gets the specified version of the specified key in the specified managed HSM.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the Managed HSM Pool within the specified resource group.
     * @param keyName The name of the key to be created. The value you provide may be copied globally for the purpose of
     * running the service. The value provided should not include personally identifiable or sensitive information.
     * @param keyVersion The version of the key to be retrieved.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified version of the specified key in the specified managed HSM along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ManagedHsmKeyInner> getVersionWithResponse(String resourceGroupName, String name, String keyName,
        String keyVersion, Context context);

    /**
     * Gets the specified version of the specified key in the specified managed HSM.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the Managed HSM Pool within the specified resource group.
     * @param keyName The name of the key to be created. The value you provide may be copied globally for the purpose of
     * running the service. The value provided should not include personally identifiable or sensitive information.
     * @param keyVersion The version of the key to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified version of the specified key in the specified managed HSM.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ManagedHsmKeyInner getVersion(String resourceGroupName, String name, String keyName, String keyVersion);

    /**
     * Lists the versions of the specified key in the specified managed HSM.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the Managed HSM Pool within the specified resource group.
     * @param keyName The name of the key to be created. The value you provide may be copied globally for the purpose of
     * running the service. The value provided should not include personally identifiable or sensitive information.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the page of keys as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<ManagedHsmKeyInner> listVersionsAsync(String resourceGroupName, String name, String keyName);

    /**
     * Lists the versions of the specified key in the specified managed HSM.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the Managed HSM Pool within the specified resource group.
     * @param keyName The name of the key to be created. The value you provide may be copied globally for the purpose of
     * running the service. The value provided should not include personally identifiable or sensitive information.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the page of keys as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ManagedHsmKeyInner> listVersions(String resourceGroupName, String name, String keyName);

    /**
     * Lists the versions of the specified key in the specified managed HSM.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the Managed HSM Pool within the specified resource group.
     * @param keyName The name of the key to be created. The value you provide may be copied globally for the purpose of
     * running the service. The value provided should not include personally identifiable or sensitive information.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the page of keys as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ManagedHsmKeyInner> listVersions(String resourceGroupName, String name, String keyName,
        Context context);
}
