// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.keyvault.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Properties of the secret.
 */
@Fluent
public final class SecretPatchProperties implements JsonSerializable<SecretPatchProperties> {
    /*
     * The value of the secret.
     */
    private String value;

    /*
     * The content type of the secret.
     */
    private String contentType;

    /*
     * The attributes of the secret.
     */
    private SecretAttributes attributes;

    /**
     * Creates an instance of SecretPatchProperties class.
     */
    public SecretPatchProperties() {
    }

    /**
     * Get the value property: The value of the secret.
     * 
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Set the value property: The value of the secret.
     * 
     * @param value the value value to set.
     * @return the SecretPatchProperties object itself.
     */
    public SecretPatchProperties withValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * Get the contentType property: The content type of the secret.
     * 
     * @return the contentType value.
     */
    public String contentType() {
        return this.contentType;
    }

    /**
     * Set the contentType property: The content type of the secret.
     * 
     * @param contentType the contentType value to set.
     * @return the SecretPatchProperties object itself.
     */
    public SecretPatchProperties withContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    /**
     * Get the attributes property: The attributes of the secret.
     * 
     * @return the attributes value.
     */
    public SecretAttributes attributes() {
        return this.attributes;
    }

    /**
     * Set the attributes property: The attributes of the secret.
     * 
     * @param attributes the attributes value to set.
     * @return the SecretPatchProperties object itself.
     */
    public SecretPatchProperties withAttributes(SecretAttributes attributes) {
        this.attributes = attributes;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (attributes() != null) {
            attributes().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("value", this.value);
        jsonWriter.writeStringField("contentType", this.contentType);
        jsonWriter.writeJsonField("attributes", this.attributes);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SecretPatchProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SecretPatchProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SecretPatchProperties.
     */
    public static SecretPatchProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SecretPatchProperties deserializedSecretPatchProperties = new SecretPatchProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    deserializedSecretPatchProperties.value = reader.getString();
                } else if ("contentType".equals(fieldName)) {
                    deserializedSecretPatchProperties.contentType = reader.getString();
                } else if ("attributes".equals(fieldName)) {
                    deserializedSecretPatchProperties.attributes = SecretAttributes.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSecretPatchProperties;
        });
    }
}
