/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.keyvault.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.keyvault.fluent.models.KeyProperties;
import com.azure.resourcemanager.keyvault.models.JsonWebKeyCurveName;
import com.azure.resourcemanager.keyvault.models.JsonWebKeyOperation;
import com.azure.resourcemanager.keyvault.models.JsonWebKeyType;
import com.azure.resourcemanager.keyvault.models.KeyAttributes;
import com.azure.resourcemanager.keyvault.models.KeyReleasePolicy;
import com.azure.resourcemanager.keyvault.models.RotationPolicy;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class KeyInner
extends Resource {
    private KeyProperties innerProperties = new KeyProperties();
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(KeyInner.class);

    private KeyProperties innerProperties() {
        return this.innerProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public KeyInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public KeyInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public KeyAttributes attributes() {
        return this.innerProperties() == null ? null : this.innerProperties().attributes();
    }

    public KeyInner withAttributes(KeyAttributes attributes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new KeyProperties();
        }
        this.innerProperties().withAttributes(attributes);
        return this;
    }

    public JsonWebKeyType kty() {
        return this.innerProperties() == null ? null : this.innerProperties().kty();
    }

    public KeyInner withKty(JsonWebKeyType kty) {
        if (this.innerProperties() == null) {
            this.innerProperties = new KeyProperties();
        }
        this.innerProperties().withKty(kty);
        return this;
    }

    public List<JsonWebKeyOperation> keyOps() {
        return this.innerProperties() == null ? null : this.innerProperties().keyOps();
    }

    public KeyInner withKeyOps(List<JsonWebKeyOperation> keyOps) {
        if (this.innerProperties() == null) {
            this.innerProperties = new KeyProperties();
        }
        this.innerProperties().withKeyOps(keyOps);
        return this;
    }

    public Integer keySize() {
        return this.innerProperties() == null ? null : this.innerProperties().keySize();
    }

    public KeyInner withKeySize(Integer keySize) {
        if (this.innerProperties() == null) {
            this.innerProperties = new KeyProperties();
        }
        this.innerProperties().withKeySize(keySize);
        return this;
    }

    public JsonWebKeyCurveName curveName() {
        return this.innerProperties() == null ? null : this.innerProperties().curveName();
    }

    public KeyInner withCurveName(JsonWebKeyCurveName curveName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new KeyProperties();
        }
        this.innerProperties().withCurveName(curveName);
        return this;
    }

    public String keyUri() {
        return this.innerProperties() == null ? null : this.innerProperties().keyUri();
    }

    public String keyUriWithVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().keyUriWithVersion();
    }

    public RotationPolicy rotationPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().rotationPolicy();
    }

    public KeyInner withRotationPolicy(RotationPolicy rotationPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new KeyProperties();
        }
        this.innerProperties().withRotationPolicy(rotationPolicy);
        return this;
    }

    public KeyReleasePolicy releasePolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().releasePolicy();
    }

    public KeyInner withReleasePolicy(KeyReleasePolicy releasePolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new KeyProperties();
        }
        this.innerProperties().withReleasePolicy(releasePolicy);
        return this;
    }

    public void validate() {
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model KeyInner"));
        }
        this.innerProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static KeyInner fromJson(JsonReader jsonReader) throws IOException {
        return (KeyInner)((Object)jsonReader.readObject(reader -> {
            KeyInner deserializedKeyInner = new KeyInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedKeyInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedKeyInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedKeyInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedKeyInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedKeyInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedKeyInner.innerProperties = KeyProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKeyInner;
        }));
    }
}

