// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.keyvault.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.keyvault.fluent.models.MhsmPrivateEndpointConnectionInner;
import java.io.IOException;
import java.util.List;

/**
 * List of private endpoint connections associated with a managed HSM Pools.
 */
@Fluent
public final class MhsmPrivateEndpointConnectionsListResult
    implements JsonSerializable<MhsmPrivateEndpointConnectionsListResult> {
    /*
     * The private endpoint connection associated with a managed HSM Pools.
     */
    private List<MhsmPrivateEndpointConnectionInner> value;

    /*
     * The URL to get the next set of managed HSM Pools.
     */
    private String nextLink;

    /**
     * Creates an instance of MhsmPrivateEndpointConnectionsListResult class.
     */
    public MhsmPrivateEndpointConnectionsListResult() {
    }

    /**
     * Get the value property: The private endpoint connection associated with a managed HSM Pools.
     * 
     * @return the value value.
     */
    public List<MhsmPrivateEndpointConnectionInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The private endpoint connection associated with a managed HSM Pools.
     * 
     * @param value the value value to set.
     * @return the MhsmPrivateEndpointConnectionsListResult object itself.
     */
    public MhsmPrivateEndpointConnectionsListResult withValue(List<MhsmPrivateEndpointConnectionInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URL to get the next set of managed HSM Pools.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The URL to get the next set of managed HSM Pools.
     * 
     * @param nextLink the nextLink value to set.
     * @return the MhsmPrivateEndpointConnectionsListResult object itself.
     */
    public MhsmPrivateEndpointConnectionsListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MhsmPrivateEndpointConnectionsListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MhsmPrivateEndpointConnectionsListResult if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MhsmPrivateEndpointConnectionsListResult.
     */
    public static MhsmPrivateEndpointConnectionsListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MhsmPrivateEndpointConnectionsListResult deserializedMhsmPrivateEndpointConnectionsListResult
                = new MhsmPrivateEndpointConnectionsListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<MhsmPrivateEndpointConnectionInner> value
                        = reader.readArray(reader1 -> MhsmPrivateEndpointConnectionInner.fromJson(reader1));
                    deserializedMhsmPrivateEndpointConnectionsListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedMhsmPrivateEndpointConnectionsListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMhsmPrivateEndpointConnectionsListResult;
        });
    }
}
