// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.keyvault.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The KeyRotationPolicyAttributes model.
 */
@Fluent
public final class KeyRotationPolicyAttributes implements JsonSerializable<KeyRotationPolicyAttributes> {
    /*
     * Creation time in seconds since 1970-01-01T00:00:00Z.
     */
    private Long created;

    /*
     * Last updated time in seconds since 1970-01-01T00:00:00Z.
     */
    private Long updated;

    /*
     * The expiration time for the new key version. It should be in ISO8601 format. Eg: 'P90D', 'P1Y'.
     */
    private String expiryTime;

    /**
     * Creates an instance of KeyRotationPolicyAttributes class.
     */
    public KeyRotationPolicyAttributes() {
    }

    /**
     * Get the created property: Creation time in seconds since 1970-01-01T00:00:00Z.
     * 
     * @return the created value.
     */
    public Long created() {
        return this.created;
    }

    /**
     * Get the updated property: Last updated time in seconds since 1970-01-01T00:00:00Z.
     * 
     * @return the updated value.
     */
    public Long updated() {
        return this.updated;
    }

    /**
     * Get the expiryTime property: The expiration time for the new key version. It should be in ISO8601 format. Eg:
     * 'P90D', 'P1Y'.
     * 
     * @return the expiryTime value.
     */
    public String expiryTime() {
        return this.expiryTime;
    }

    /**
     * Set the expiryTime property: The expiration time for the new key version. It should be in ISO8601 format. Eg:
     * 'P90D', 'P1Y'.
     * 
     * @param expiryTime the expiryTime value to set.
     * @return the KeyRotationPolicyAttributes object itself.
     */
    public KeyRotationPolicyAttributes withExpiryTime(String expiryTime) {
        this.expiryTime = expiryTime;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("expiryTime", this.expiryTime);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KeyRotationPolicyAttributes from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KeyRotationPolicyAttributes if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the KeyRotationPolicyAttributes.
     */
    public static KeyRotationPolicyAttributes fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KeyRotationPolicyAttributes deserializedKeyRotationPolicyAttributes = new KeyRotationPolicyAttributes();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("created".equals(fieldName)) {
                    deserializedKeyRotationPolicyAttributes.created = reader.getNullable(JsonReader::getLong);
                } else if ("updated".equals(fieldName)) {
                    deserializedKeyRotationPolicyAttributes.updated = reader.getNullable(JsonReader::getLong);
                } else if ("expiryTime".equals(fieldName)) {
                    deserializedKeyRotationPolicyAttributes.expiryTime = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedKeyRotationPolicyAttributes;
        });
    }
}
