// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.keyvault.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.keyvault.fluent.models.VaultInner;
import java.io.IOException;
import java.util.List;

/**
 * List of vaults.
 */
@Fluent
public final class VaultListResult implements JsonSerializable<VaultListResult> {
    /*
     * The list of vaults.
     */
    private List<VaultInner> value;

    /*
     * The URL to get the next set of vaults.
     */
    private String nextLink;

    /**
     * Creates an instance of VaultListResult class.
     */
    public VaultListResult() {
    }

    /**
     * Get the value property: The list of vaults.
     * 
     * @return the value value.
     */
    public List<VaultInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The list of vaults.
     * 
     * @param value the value value to set.
     * @return the VaultListResult object itself.
     */
    public VaultListResult withValue(List<VaultInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URL to get the next set of vaults.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The URL to get the next set of vaults.
     * 
     * @param nextLink the nextLink value to set.
     * @return the VaultListResult object itself.
     */
    public VaultListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VaultListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VaultListResult if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the VaultListResult.
     */
    public static VaultListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VaultListResult deserializedVaultListResult = new VaultListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<VaultInner> value = reader.readArray(reader1 -> VaultInner.fromJson(reader1));
                    deserializedVaultListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedVaultListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVaultListResult;
        });
    }
}
