// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.keyvault.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.resourcemanager.keyvault.fluent.ManagedHsmKeysClient;
import com.azure.resourcemanager.keyvault.fluent.models.ManagedHsmKeyInner;
import com.azure.resourcemanager.keyvault.models.ManagedHsmKeyCreateParameters;
import com.azure.resourcemanager.keyvault.models.ManagedHsmKeyListResult;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in ManagedHsmKeysClient.
 */
public final class ManagedHsmKeysClientImpl implements ManagedHsmKeysClient {
    /**
     * The proxy service used to perform REST calls.
     */
    private final ManagedHsmKeysService service;

    /**
     * The service client containing this operation class.
     */
    private final KeyVaultManagementClientImpl client;

    /**
     * Initializes an instance of ManagedHsmKeysClientImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    ManagedHsmKeysClientImpl(KeyVaultManagementClientImpl client) {
        this.service
            = RestProxy.create(ManagedHsmKeysService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for KeyVaultManagementClientManagedHsmKeys to be used by the proxy
     * service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "KeyVaultManagementCl")
    public interface ManagedHsmKeysService {
        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/managedHSMs/{name}/keys/{keyName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ManagedHsmKeyInner>> createIfNotExist(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @QueryParam("api-version") String apiVersion, @PathParam("keyName") String keyName,
            @BodyParam("application/json") ManagedHsmKeyCreateParameters parameters,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/managedHSMs/{name}/keys/{keyName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ManagedHsmKeyInner>> get(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("keyName") String keyName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/managedHSMs/{name}/keys")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ManagedHsmKeyListResult>> list(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/managedHSMs/{name}/keys/{keyName}/versions/{keyVersion}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ManagedHsmKeyInner>> getVersion(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("keyName") String keyName, @PathParam("keyVersion") String keyVersion,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/managedHSMs/{name}/keys/{keyName}/versions")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ManagedHsmKeyListResult>> listVersions(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("name") String name,
            @PathParam("keyName") String keyName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ManagedHsmKeyListResult>> listNext(@PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("$host") String endpoint, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ManagedHsmKeyListResult>> listVersionsNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Creates the first version of a new key if it does not exist. If it already exists, then the existing key is
     * returned without any write operations being performed. This API does not create subsequent versions, and does not
     * update existing keys.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the Managed HSM Pool within the specified resource group.
     * @param keyName The name of the key to be created. The value you provide may be copied globally for the purpose of
     * running the service. The value provided should not include personally identifiable or sensitive information.
     * @param parameters The parameters used to create the specified key.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ManagedHsmKeyInner>> createIfNotExistWithResponseAsync(String resourceGroupName, String name,
        String keyName, ManagedHsmKeyCreateParameters parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (keyName == null) {
            return Mono.error(new IllegalArgumentException("Parameter keyName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createIfNotExist(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, name, this.client.getApiVersion(), keyName, parameters, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Creates the first version of a new key if it does not exist. If it already exists, then the existing key is
     * returned without any write operations being performed. This API does not create subsequent versions, and does not
     * update existing keys.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the Managed HSM Pool within the specified resource group.
     * @param keyName The name of the key to be created. The value you provide may be copied globally for the purpose of
     * running the service. The value provided should not include personally identifiable or sensitive information.
     * @param parameters The parameters used to create the specified key.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<ManagedHsmKeyInner>> createIfNotExistWithResponseAsync(String resourceGroupName, String name,
        String keyName, ManagedHsmKeyCreateParameters parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (keyName == null) {
            return Mono.error(new IllegalArgumentException("Parameter keyName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createIfNotExist(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            name, this.client.getApiVersion(), keyName, parameters, accept, context);
    }

    /**
     * Creates the first version of a new key if it does not exist. If it already exists, then the existing key is
     * returned without any write operations being performed. This API does not create subsequent versions, and does not
     * update existing keys.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the Managed HSM Pool within the specified resource group.
     * @param keyName The name of the key to be created. The value you provide may be copied globally for the purpose of
     * running the service. The value provided should not include personally identifiable or sensitive information.
     * @param parameters The parameters used to create the specified key.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ManagedHsmKeyInner> createIfNotExistAsync(String resourceGroupName, String name, String keyName,
        ManagedHsmKeyCreateParameters parameters) {
        return createIfNotExistWithResponseAsync(resourceGroupName, name, keyName, parameters)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Creates the first version of a new key if it does not exist. If it already exists, then the existing key is
     * returned without any write operations being performed. This API does not create subsequent versions, and does not
     * update existing keys.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the Managed HSM Pool within the specified resource group.
     * @param keyName The name of the key to be created. The value you provide may be copied globally for the purpose of
     * running the service. The value provided should not include personally identifiable or sensitive information.
     * @param parameters The parameters used to create the specified key.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ManagedHsmKeyInner> createIfNotExistWithResponse(String resourceGroupName, String name,
        String keyName, ManagedHsmKeyCreateParameters parameters, Context context) {
        return createIfNotExistWithResponseAsync(resourceGroupName, name, keyName, parameters, context).block();
    }

    /**
     * Creates the first version of a new key if it does not exist. If it already exists, then the existing key is
     * returned without any write operations being performed. This API does not create subsequent versions, and does not
     * update existing keys.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the Managed HSM Pool within the specified resource group.
     * @param keyName The name of the key to be created. The value you provide may be copied globally for the purpose of
     * running the service. The value provided should not include personally identifiable or sensitive information.
     * @param parameters The parameters used to create the specified key.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ManagedHsmKeyInner createIfNotExist(String resourceGroupName, String name, String keyName,
        ManagedHsmKeyCreateParameters parameters) {
        return createIfNotExistWithResponse(resourceGroupName, name, keyName, parameters, Context.NONE).getValue();
    }

    /**
     * Gets the current version of the specified key from the specified managed HSM.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the Managed HSM Pool within the specified resource group.
     * @param keyName The name of the key to be created. The value you provide may be copied globally for the purpose of
     * running the service. The value provided should not include personally identifiable or sensitive information.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the current version of the specified key from the specified managed HSM along with {@link Response} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ManagedHsmKeyInner>> getWithResponseAsync(String resourceGroupName, String name,
        String keyName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (keyName == null) {
            return Mono.error(new IllegalArgumentException("Parameter keyName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.get(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, name, keyName, this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the current version of the specified key from the specified managed HSM.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the Managed HSM Pool within the specified resource group.
     * @param keyName The name of the key to be created. The value you provide may be copied globally for the purpose of
     * running the service. The value provided should not include personally identifiable or sensitive information.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the current version of the specified key from the specified managed HSM along with {@link Response} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<ManagedHsmKeyInner>> getWithResponseAsync(String resourceGroupName, String name,
        String keyName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (keyName == null) {
            return Mono.error(new IllegalArgumentException("Parameter keyName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, name, keyName,
            this.client.getApiVersion(), accept, context);
    }

    /**
     * Gets the current version of the specified key from the specified managed HSM.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the Managed HSM Pool within the specified resource group.
     * @param keyName The name of the key to be created. The value you provide may be copied globally for the purpose of
     * running the service. The value provided should not include personally identifiable or sensitive information.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the current version of the specified key from the specified managed HSM on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ManagedHsmKeyInner> getAsync(String resourceGroupName, String name, String keyName) {
        return getWithResponseAsync(resourceGroupName, name, keyName).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the current version of the specified key from the specified managed HSM.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the Managed HSM Pool within the specified resource group.
     * @param keyName The name of the key to be created. The value you provide may be copied globally for the purpose of
     * running the service. The value provided should not include personally identifiable or sensitive information.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the current version of the specified key from the specified managed HSM along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ManagedHsmKeyInner> getWithResponse(String resourceGroupName, String name, String keyName,
        Context context) {
        return getWithResponseAsync(resourceGroupName, name, keyName, context).block();
    }

    /**
     * Gets the current version of the specified key from the specified managed HSM.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the Managed HSM Pool within the specified resource group.
     * @param keyName The name of the key to be created. The value you provide may be copied globally for the purpose of
     * running the service. The value provided should not include personally identifiable or sensitive information.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the current version of the specified key from the specified managed HSM.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ManagedHsmKeyInner get(String resourceGroupName, String name, String keyName) {
        return getWithResponse(resourceGroupName, name, keyName, Context.NONE).getValue();
    }

    /**
     * Lists the keys in the specified managed HSM.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the Managed HSM Pool within the specified resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the page of keys along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ManagedHsmKeyInner>> listSinglePageAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.list(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, name, this.client.getApiVersion(), accept, context))
            .<PagedResponse<ManagedHsmKeyInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Lists the keys in the specified managed HSM.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the Managed HSM Pool within the specified resource group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the page of keys along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ManagedHsmKeyInner>> listSinglePageAsync(String resourceGroupName, String name,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, name,
                this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Lists the keys in the specified managed HSM.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the Managed HSM Pool within the specified resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the page of keys as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<ManagedHsmKeyInner> listAsync(String resourceGroupName, String name) {
        return new PagedFlux<>(() -> listSinglePageAsync(resourceGroupName, name),
            nextLink -> listNextSinglePageAsync(nextLink));
    }

    /**
     * Lists the keys in the specified managed HSM.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the Managed HSM Pool within the specified resource group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the page of keys as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<ManagedHsmKeyInner> listAsync(String resourceGroupName, String name, Context context) {
        return new PagedFlux<>(() -> listSinglePageAsync(resourceGroupName, name, context),
            nextLink -> listNextSinglePageAsync(nextLink, context));
    }

    /**
     * Lists the keys in the specified managed HSM.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the Managed HSM Pool within the specified resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the page of keys as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ManagedHsmKeyInner> list(String resourceGroupName, String name) {
        return new PagedIterable<>(listAsync(resourceGroupName, name));
    }

    /**
     * Lists the keys in the specified managed HSM.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the Managed HSM Pool within the specified resource group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the page of keys as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ManagedHsmKeyInner> list(String resourceGroupName, String name, Context context) {
        return new PagedIterable<>(listAsync(resourceGroupName, name, context));
    }

    /**
     * Gets the specified version of the specified key in the specified managed HSM.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the Managed HSM Pool within the specified resource group.
     * @param keyName The name of the key to be created. The value you provide may be copied globally for the purpose of
     * running the service. The value provided should not include personally identifiable or sensitive information.
     * @param keyVersion The version of the key to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified version of the specified key in the specified managed HSM along with {@link Response} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ManagedHsmKeyInner>> getVersionWithResponseAsync(String resourceGroupName, String name,
        String keyName, String keyVersion) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (keyName == null) {
            return Mono.error(new IllegalArgumentException("Parameter keyName is required and cannot be null."));
        }
        if (keyVersion == null) {
            return Mono.error(new IllegalArgumentException("Parameter keyVersion is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getVersion(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, name, keyName, keyVersion, this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the specified version of the specified key in the specified managed HSM.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the Managed HSM Pool within the specified resource group.
     * @param keyName The name of the key to be created. The value you provide may be copied globally for the purpose of
     * running the service. The value provided should not include personally identifiable or sensitive information.
     * @param keyVersion The version of the key to be retrieved.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified version of the specified key in the specified managed HSM along with {@link Response} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<ManagedHsmKeyInner>> getVersionWithResponseAsync(String resourceGroupName, String name,
        String keyName, String keyVersion, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (keyName == null) {
            return Mono.error(new IllegalArgumentException("Parameter keyName is required and cannot be null."));
        }
        if (keyVersion == null) {
            return Mono.error(new IllegalArgumentException("Parameter keyVersion is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getVersion(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, name,
            keyName, keyVersion, this.client.getApiVersion(), accept, context);
    }

    /**
     * Gets the specified version of the specified key in the specified managed HSM.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the Managed HSM Pool within the specified resource group.
     * @param keyName The name of the key to be created. The value you provide may be copied globally for the purpose of
     * running the service. The value provided should not include personally identifiable or sensitive information.
     * @param keyVersion The version of the key to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified version of the specified key in the specified managed HSM on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ManagedHsmKeyInner> getVersionAsync(String resourceGroupName, String name, String keyName,
        String keyVersion) {
        return getVersionWithResponseAsync(resourceGroupName, name, keyName, keyVersion)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the specified version of the specified key in the specified managed HSM.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the Managed HSM Pool within the specified resource group.
     * @param keyName The name of the key to be created. The value you provide may be copied globally for the purpose of
     * running the service. The value provided should not include personally identifiable or sensitive information.
     * @param keyVersion The version of the key to be retrieved.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified version of the specified key in the specified managed HSM along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ManagedHsmKeyInner> getVersionWithResponse(String resourceGroupName, String name, String keyName,
        String keyVersion, Context context) {
        return getVersionWithResponseAsync(resourceGroupName, name, keyName, keyVersion, context).block();
    }

    /**
     * Gets the specified version of the specified key in the specified managed HSM.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the Managed HSM Pool within the specified resource group.
     * @param keyName The name of the key to be created. The value you provide may be copied globally for the purpose of
     * running the service. The value provided should not include personally identifiable or sensitive information.
     * @param keyVersion The version of the key to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified version of the specified key in the specified managed HSM.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ManagedHsmKeyInner getVersion(String resourceGroupName, String name, String keyName, String keyVersion) {
        return getVersionWithResponse(resourceGroupName, name, keyName, keyVersion, Context.NONE).getValue();
    }

    /**
     * Lists the versions of the specified key in the specified managed HSM.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the Managed HSM Pool within the specified resource group.
     * @param keyName The name of the key to be created. The value you provide may be copied globally for the purpose of
     * running the service. The value provided should not include personally identifiable or sensitive information.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the page of keys along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ManagedHsmKeyInner>> listVersionsSinglePageAsync(String resourceGroupName, String name,
        String keyName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (keyName == null) {
            return Mono.error(new IllegalArgumentException("Parameter keyName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listVersions(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, name, keyName, this.client.getApiVersion(), accept, context))
            .<PagedResponse<ManagedHsmKeyInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Lists the versions of the specified key in the specified managed HSM.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the Managed HSM Pool within the specified resource group.
     * @param keyName The name of the key to be created. The value you provide may be copied globally for the purpose of
     * running the service. The value provided should not include personally identifiable or sensitive information.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the page of keys along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ManagedHsmKeyInner>> listVersionsSinglePageAsync(String resourceGroupName, String name,
        String keyName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (keyName == null) {
            return Mono.error(new IllegalArgumentException("Parameter keyName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listVersions(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, name, keyName,
                this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Lists the versions of the specified key in the specified managed HSM.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the Managed HSM Pool within the specified resource group.
     * @param keyName The name of the key to be created. The value you provide may be copied globally for the purpose of
     * running the service. The value provided should not include personally identifiable or sensitive information.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the page of keys as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<ManagedHsmKeyInner> listVersionsAsync(String resourceGroupName, String name, String keyName) {
        return new PagedFlux<>(() -> listVersionsSinglePageAsync(resourceGroupName, name, keyName),
            nextLink -> listVersionsNextSinglePageAsync(nextLink));
    }

    /**
     * Lists the versions of the specified key in the specified managed HSM.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the Managed HSM Pool within the specified resource group.
     * @param keyName The name of the key to be created. The value you provide may be copied globally for the purpose of
     * running the service. The value provided should not include personally identifiable or sensitive information.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the page of keys as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<ManagedHsmKeyInner> listVersionsAsync(String resourceGroupName, String name, String keyName,
        Context context) {
        return new PagedFlux<>(() -> listVersionsSinglePageAsync(resourceGroupName, name, keyName, context),
            nextLink -> listVersionsNextSinglePageAsync(nextLink, context));
    }

    /**
     * Lists the versions of the specified key in the specified managed HSM.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the Managed HSM Pool within the specified resource group.
     * @param keyName The name of the key to be created. The value you provide may be copied globally for the purpose of
     * running the service. The value provided should not include personally identifiable or sensitive information.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the page of keys as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ManagedHsmKeyInner> listVersions(String resourceGroupName, String name, String keyName) {
        return new PagedIterable<>(listVersionsAsync(resourceGroupName, name, keyName));
    }

    /**
     * Lists the versions of the specified key in the specified managed HSM.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name The name of the Managed HSM Pool within the specified resource group.
     * @param keyName The name of the key to be created. The value you provide may be copied globally for the purpose of
     * running the service. The value provided should not include personally identifiable or sensitive information.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the page of keys as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ManagedHsmKeyInner> listVersions(String resourceGroupName, String name, String keyName,
        Context context) {
        return new PagedIterable<>(listVersionsAsync(resourceGroupName, name, keyName, context));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the page of keys along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ManagedHsmKeyInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.listNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<ManagedHsmKeyInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the page of keys along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ManagedHsmKeyInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the page of keys along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ManagedHsmKeyInner>> listVersionsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listVersionsNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<ManagedHsmKeyInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the page of keys along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ManagedHsmKeyInner>> listVersionsNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listVersionsNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }
}
