// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.keyvault.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * A set of rules governing the network accessibility of a managed hsm pool.
 */
@Fluent
public final class MhsmNetworkRuleSet implements JsonSerializable<MhsmNetworkRuleSet> {
    /*
     * Tells what traffic can bypass network rules. This can be 'AzureServices' or 'None'. If not specified the default
     * is 'AzureServices'.
     */
    private NetworkRuleBypassOptions bypass;

    /*
     * The default action when no rule from ipRules and from virtualNetworkRules match. This is only used after the
     * bypass property has been evaluated.
     */
    private NetworkRuleAction defaultAction;

    /*
     * The list of IP address rules.
     */
    private List<MhsmipRule> ipRules;

    /*
     * The list of virtual network rules.
     */
    private List<MhsmVirtualNetworkRule> virtualNetworkRules;

    /**
     * Creates an instance of MhsmNetworkRuleSet class.
     */
    public MhsmNetworkRuleSet() {
    }

    /**
     * Get the bypass property: Tells what traffic can bypass network rules. This can be 'AzureServices' or 'None'. If
     * not specified the default is 'AzureServices'.
     * 
     * @return the bypass value.
     */
    public NetworkRuleBypassOptions bypass() {
        return this.bypass;
    }

    /**
     * Set the bypass property: Tells what traffic can bypass network rules. This can be 'AzureServices' or 'None'. If
     * not specified the default is 'AzureServices'.
     * 
     * @param bypass the bypass value to set.
     * @return the MhsmNetworkRuleSet object itself.
     */
    public MhsmNetworkRuleSet withBypass(NetworkRuleBypassOptions bypass) {
        this.bypass = bypass;
        return this;
    }

    /**
     * Get the defaultAction property: The default action when no rule from ipRules and from virtualNetworkRules match.
     * This is only used after the bypass property has been evaluated.
     * 
     * @return the defaultAction value.
     */
    public NetworkRuleAction defaultAction() {
        return this.defaultAction;
    }

    /**
     * Set the defaultAction property: The default action when no rule from ipRules and from virtualNetworkRules match.
     * This is only used after the bypass property has been evaluated.
     * 
     * @param defaultAction the defaultAction value to set.
     * @return the MhsmNetworkRuleSet object itself.
     */
    public MhsmNetworkRuleSet withDefaultAction(NetworkRuleAction defaultAction) {
        this.defaultAction = defaultAction;
        return this;
    }

    /**
     * Get the ipRules property: The list of IP address rules.
     * 
     * @return the ipRules value.
     */
    public List<MhsmipRule> ipRules() {
        return this.ipRules;
    }

    /**
     * Set the ipRules property: The list of IP address rules.
     * 
     * @param ipRules the ipRules value to set.
     * @return the MhsmNetworkRuleSet object itself.
     */
    public MhsmNetworkRuleSet withIpRules(List<MhsmipRule> ipRules) {
        this.ipRules = ipRules;
        return this;
    }

    /**
     * Get the virtualNetworkRules property: The list of virtual network rules.
     * 
     * @return the virtualNetworkRules value.
     */
    public List<MhsmVirtualNetworkRule> virtualNetworkRules() {
        return this.virtualNetworkRules;
    }

    /**
     * Set the virtualNetworkRules property: The list of virtual network rules.
     * 
     * @param virtualNetworkRules the virtualNetworkRules value to set.
     * @return the MhsmNetworkRuleSet object itself.
     */
    public MhsmNetworkRuleSet withVirtualNetworkRules(List<MhsmVirtualNetworkRule> virtualNetworkRules) {
        this.virtualNetworkRules = virtualNetworkRules;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (ipRules() != null) {
            ipRules().forEach(e -> e.validate());
        }
        if (virtualNetworkRules() != null) {
            virtualNetworkRules().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("bypass", this.bypass == null ? null : this.bypass.toString());
        jsonWriter.writeStringField("defaultAction", this.defaultAction == null ? null : this.defaultAction.toString());
        jsonWriter.writeArrayField("ipRules", this.ipRules, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("virtualNetworkRules", this.virtualNetworkRules,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MhsmNetworkRuleSet from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MhsmNetworkRuleSet if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the MhsmNetworkRuleSet.
     */
    public static MhsmNetworkRuleSet fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MhsmNetworkRuleSet deserializedMhsmNetworkRuleSet = new MhsmNetworkRuleSet();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("bypass".equals(fieldName)) {
                    deserializedMhsmNetworkRuleSet.bypass = NetworkRuleBypassOptions.fromString(reader.getString());
                } else if ("defaultAction".equals(fieldName)) {
                    deserializedMhsmNetworkRuleSet.defaultAction = NetworkRuleAction.fromString(reader.getString());
                } else if ("ipRules".equals(fieldName)) {
                    List<MhsmipRule> ipRules = reader.readArray(reader1 -> MhsmipRule.fromJson(reader1));
                    deserializedMhsmNetworkRuleSet.ipRules = ipRules;
                } else if ("virtualNetworkRules".equals(fieldName)) {
                    List<MhsmVirtualNetworkRule> virtualNetworkRules
                        = reader.readArray(reader1 -> MhsmVirtualNetworkRule.fromJson(reader1));
                    deserializedMhsmNetworkRuleSet.virtualNetworkRules = virtualNetworkRules;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMhsmNetworkRuleSet;
        });
    }
}
