/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.keyvault.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.keyvault.models.MhsmPrivateEndpoint;
import com.azure.resourcemanager.keyvault.models.MhsmPrivateLinkServiceConnectionState;
import com.azure.resourcemanager.keyvault.models.PrivateEndpointConnectionProvisioningState;
import java.io.IOException;

public final class MhsmPrivateEndpointConnectionProperties
implements JsonSerializable<MhsmPrivateEndpointConnectionProperties> {
    private MhsmPrivateEndpoint privateEndpoint;
    private MhsmPrivateLinkServiceConnectionState privateLinkServiceConnectionState;
    private PrivateEndpointConnectionProvisioningState provisioningState;

    public MhsmPrivateEndpoint privateEndpoint() {
        return this.privateEndpoint;
    }

    public MhsmPrivateEndpointConnectionProperties withPrivateEndpoint(MhsmPrivateEndpoint privateEndpoint) {
        this.privateEndpoint = privateEndpoint;
        return this;
    }

    public MhsmPrivateLinkServiceConnectionState privateLinkServiceConnectionState() {
        return this.privateLinkServiceConnectionState;
    }

    public MhsmPrivateEndpointConnectionProperties withPrivateLinkServiceConnectionState(MhsmPrivateLinkServiceConnectionState privateLinkServiceConnectionState) {
        this.privateLinkServiceConnectionState = privateLinkServiceConnectionState;
        return this;
    }

    public PrivateEndpointConnectionProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public MhsmPrivateEndpointConnectionProperties withProvisioningState(PrivateEndpointConnectionProvisioningState provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    public void validate() {
        if (this.privateEndpoint() != null) {
            this.privateEndpoint().validate();
        }
        if (this.privateLinkServiceConnectionState() != null) {
            this.privateLinkServiceConnectionState().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("privateEndpoint", (JsonSerializable)this.privateEndpoint);
        jsonWriter.writeJsonField("privateLinkServiceConnectionState", (JsonSerializable)this.privateLinkServiceConnectionState);
        jsonWriter.writeStringField("provisioningState", this.provisioningState == null ? null : this.provisioningState.toString());
        return jsonWriter.writeEndObject();
    }

    public static MhsmPrivateEndpointConnectionProperties fromJson(JsonReader jsonReader) throws IOException {
        return (MhsmPrivateEndpointConnectionProperties)jsonReader.readObject(reader -> {
            MhsmPrivateEndpointConnectionProperties deserializedMhsmPrivateEndpointConnectionProperties = new MhsmPrivateEndpointConnectionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("privateEndpoint".equals(fieldName)) {
                    deserializedMhsmPrivateEndpointConnectionProperties.privateEndpoint = MhsmPrivateEndpoint.fromJson(reader);
                    continue;
                }
                if ("privateLinkServiceConnectionState".equals(fieldName)) {
                    deserializedMhsmPrivateEndpointConnectionProperties.privateLinkServiceConnectionState = MhsmPrivateLinkServiceConnectionState.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedMhsmPrivateEndpointConnectionProperties.provisioningState = PrivateEndpointConnectionProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMhsmPrivateEndpointConnectionProperties;
        });
    }
}

