// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.keyvault.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Properties of the secret.
 */
@Fluent
public final class SecretProperties implements JsonSerializable<SecretProperties> {
    /*
     * The value of the secret. NOTE: 'value' will never be returned from the service, as APIs using this model are is
     * intended for internal use in ARM deployments. Users should use the data-plane REST service for interaction with
     * vault secrets.
     */
    private String value;

    /*
     * The content type of the secret.
     */
    private String contentType;

    /*
     * The attributes of the secret.
     */
    private SecretAttributes attributes;

    /*
     * The URI to retrieve the current version of the secret.
     */
    private String secretUri;

    /*
     * The URI to retrieve the specific version of the secret.
     */
    private String secretUriWithVersion;

    /**
     * Creates an instance of SecretProperties class.
     */
    public SecretProperties() {
    }

    /**
     * Get the value property: The value of the secret. NOTE: 'value' will never be returned from the service, as APIs
     * using this model are is intended for internal use in ARM deployments. Users should use the data-plane REST
     * service for interaction with vault secrets.
     * 
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Set the value property: The value of the secret. NOTE: 'value' will never be returned from the service, as APIs
     * using this model are is intended for internal use in ARM deployments. Users should use the data-plane REST
     * service for interaction with vault secrets.
     * 
     * @param value the value value to set.
     * @return the SecretProperties object itself.
     */
    public SecretProperties withValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * Get the contentType property: The content type of the secret.
     * 
     * @return the contentType value.
     */
    public String contentType() {
        return this.contentType;
    }

    /**
     * Set the contentType property: The content type of the secret.
     * 
     * @param contentType the contentType value to set.
     * @return the SecretProperties object itself.
     */
    public SecretProperties withContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    /**
     * Get the attributes property: The attributes of the secret.
     * 
     * @return the attributes value.
     */
    public SecretAttributes attributes() {
        return this.attributes;
    }

    /**
     * Set the attributes property: The attributes of the secret.
     * 
     * @param attributes the attributes value to set.
     * @return the SecretProperties object itself.
     */
    public SecretProperties withAttributes(SecretAttributes attributes) {
        this.attributes = attributes;
        return this;
    }

    /**
     * Get the secretUri property: The URI to retrieve the current version of the secret.
     * 
     * @return the secretUri value.
     */
    public String secretUri() {
        return this.secretUri;
    }

    /**
     * Get the secretUriWithVersion property: The URI to retrieve the specific version of the secret.
     * 
     * @return the secretUriWithVersion value.
     */
    public String secretUriWithVersion() {
        return this.secretUriWithVersion;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (attributes() != null) {
            attributes().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("value", this.value);
        jsonWriter.writeStringField("contentType", this.contentType);
        jsonWriter.writeJsonField("attributes", this.attributes);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SecretProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SecretProperties if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the SecretProperties.
     */
    public static SecretProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SecretProperties deserializedSecretProperties = new SecretProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    deserializedSecretProperties.value = reader.getString();
                } else if ("contentType".equals(fieldName)) {
                    deserializedSecretProperties.contentType = reader.getString();
                } else if ("attributes".equals(fieldName)) {
                    deserializedSecretProperties.attributes = SecretAttributes.fromJson(reader);
                } else if ("secretUri".equals(fieldName)) {
                    deserializedSecretProperties.secretUri = reader.getString();
                } else if ("secretUriWithVersion".equals(fieldName)) {
                    deserializedSecretProperties.secretUriWithVersion = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSecretProperties;
        });
    }
}
