// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.keyvault.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.keyvault.fluent.models.MhsmGeoReplicatedRegionInner;
import java.io.IOException;
import java.util.List;

/**
 * List of regions associated with a managed HSM Pools.
 */
@Fluent
public final class MhsmRegionsListResult implements JsonSerializable<MhsmRegionsListResult> {
    /*
     * The region associated with a managed HSM Pools.
     */
    private List<MhsmGeoReplicatedRegionInner> value;

    /*
     * The URL to get the next set of managed HSM Pools.
     */
    private String nextLink;

    /**
     * Creates an instance of MhsmRegionsListResult class.
     */
    public MhsmRegionsListResult() {
    }

    /**
     * Get the value property: The region associated with a managed HSM Pools.
     * 
     * @return the value value.
     */
    public List<MhsmGeoReplicatedRegionInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The region associated with a managed HSM Pools.
     * 
     * @param value the value value to set.
     * @return the MhsmRegionsListResult object itself.
     */
    public MhsmRegionsListResult withValue(List<MhsmGeoReplicatedRegionInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URL to get the next set of managed HSM Pools.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The URL to get the next set of managed HSM Pools.
     * 
     * @param nextLink the nextLink value to set.
     * @return the MhsmRegionsListResult object itself.
     */
    public MhsmRegionsListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MhsmRegionsListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MhsmRegionsListResult if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MhsmRegionsListResult.
     */
    public static MhsmRegionsListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MhsmRegionsListResult deserializedMhsmRegionsListResult = new MhsmRegionsListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<MhsmGeoReplicatedRegionInner> value
                        = reader.readArray(reader1 -> MhsmGeoReplicatedRegionInner.fromJson(reader1));
                    deserializedMhsmRegionsListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedMhsmRegionsListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMhsmRegionsListResult;
        });
    }
}
