// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.keyvault.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/** SKU of the managed HSM Pool. */
public enum ManagedHsmSkuName {
    /** Enum value Standard_B1. */
    STANDARD_B1("Standard_B1"),

    /** Enum value Custom_B32. */
    CUSTOM_B32("Custom_B32"),

    /** Enum value Custom_B6. */
    CUSTOM_B6("Custom_B6");

    /** The actual serialized value for a ManagedHsmSkuName instance. */
    private final String value;

    ManagedHsmSkuName(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a ManagedHsmSkuName instance.
     *
     * @param value the serialized value to parse.
     * @return the parsed ManagedHsmSkuName object, or null if unable to parse.
     */
    @JsonCreator
    public static ManagedHsmSkuName fromString(String value) {
        if (value == null) {
            return null;
        }
        ManagedHsmSkuName[] items = ManagedHsmSkuName.values();
        for (ManagedHsmSkuName item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /** {@inheritDoc} */
    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }
}
