/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.keyvault.implementation;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.management.Resource;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.authorization.AuthorizationManager;
import com.azure.resourcemanager.keyvault.KeyVaultManager;
import com.azure.resourcemanager.keyvault.fluent.KeyVaultManagementClient;
import com.azure.resourcemanager.keyvault.fluent.VaultsClient;
import com.azure.resourcemanager.keyvault.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.keyvault.fluent.models.PrivateLinkResourceListResultInner;
import com.azure.resourcemanager.keyvault.fluent.models.VaultInner;
import com.azure.resourcemanager.keyvault.implementation.AccessPolicyImpl;
import com.azure.resourcemanager.keyvault.implementation.KeysImpl;
import com.azure.resourcemanager.keyvault.implementation.SecretsImpl;
import com.azure.resourcemanager.keyvault.models.AccessPolicy;
import com.azure.resourcemanager.keyvault.models.AccessPolicyEntry;
import com.azure.resourcemanager.keyvault.models.CreateMode;
import com.azure.resourcemanager.keyvault.models.IpRule;
import com.azure.resourcemanager.keyvault.models.Keys;
import com.azure.resourcemanager.keyvault.models.NetworkRuleAction;
import com.azure.resourcemanager.keyvault.models.NetworkRuleBypassOptions;
import com.azure.resourcemanager.keyvault.models.NetworkRuleSet;
import com.azure.resourcemanager.keyvault.models.PrivateEndpointServiceConnectionStatus;
import com.azure.resourcemanager.keyvault.models.PrivateLinkResource;
import com.azure.resourcemanager.keyvault.models.PrivateLinkServiceConnectionState;
import com.azure.resourcemanager.keyvault.models.Secrets;
import com.azure.resourcemanager.keyvault.models.Sku;
import com.azure.resourcemanager.keyvault.models.SkuFamily;
import com.azure.resourcemanager.keyvault.models.SkuName;
import com.azure.resourcemanager.keyvault.models.Vault;
import com.azure.resourcemanager.keyvault.models.VaultCreateOrUpdateParameters;
import com.azure.resourcemanager.keyvault.models.VaultProperties;
import com.azure.resourcemanager.keyvault.models.VirtualNetworkRule;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.azure.security.keyvault.keys.KeyAsyncClient;
import com.azure.security.keyvault.keys.KeyClientBuilder;
import com.azure.security.keyvault.keys.KeyServiceVersion;
import com.azure.security.keyvault.secrets.SecretAsyncClient;
import com.azure.security.keyvault.secrets.SecretClientBuilder;
import com.azure.security.keyvault.secrets.SecretServiceVersion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

class VaultImpl
extends GroupableResourceImpl<Vault, VaultInner, VaultImpl, KeyVaultManager>
implements Vault,
Vault.Definition,
Vault.Update {
    private final ClientLogger logger = new ClientLogger(this.getClass());
    private AuthorizationManager authorizationManager;
    private List<AccessPolicyImpl> accessPolicies;
    private SecretAsyncClient secretClient;
    private KeyAsyncClient keyClient;
    private HttpPipeline vaultHttpPipeline;
    private Keys keys;
    private Secrets secrets;

    VaultImpl(String key, VaultInner innerObject, KeyVaultManager manager, AuthorizationManager authorizationManager) {
        super(key, (Resource)innerObject, (Manager)manager);
        this.authorizationManager = authorizationManager;
        this.accessPolicies = new ArrayList<AccessPolicyImpl>();
        if (innerObject != null && innerObject.properties() != null && innerObject.properties().accessPolicies() != null) {
            for (AccessPolicyEntry entry : innerObject.properties().accessPolicies()) {
                this.accessPolicies.add(new AccessPolicyImpl(entry, this));
            }
        }
        this.vaultHttpPipeline = ((KeyVaultManager)this.manager()).httpPipeline();
        this.init();
    }

    private void init() {
        if (((VaultInner)((Object)this.innerModel())).properties().vaultUri() != null) {
            String vaultUrl = this.vaultUri();
            this.secretClient = new SecretClientBuilder().vaultUrl(vaultUrl).pipeline(this.vaultHttpPipeline).serviceVersion(SecretServiceVersion.V7_2).buildAsyncClient();
            this.keyClient = new KeyClientBuilder().vaultUrl(vaultUrl).pipeline(this.vaultHttpPipeline).serviceVersion(KeyServiceVersion.V7_2).buildAsyncClient();
        }
    }

    @Override
    public HttpPipeline vaultHttpPipeline() {
        return this.vaultHttpPipeline;
    }

    @Override
    public SecretAsyncClient secretClient() {
        return this.secretClient;
    }

    @Override
    public KeyAsyncClient keyClient() {
        return this.keyClient;
    }

    @Override
    public Keys keys() {
        if (this.keys == null) {
            this.keys = new KeysImpl(this.keyClient, this.vaultHttpPipeline);
        }
        return this.keys;
    }

    @Override
    public Secrets secrets() {
        if (this.secrets == null) {
            this.secrets = new SecretsImpl(this.secretClient, this);
        }
        return this.secrets;
    }

    @Override
    public String vaultUri() {
        if (((VaultInner)((Object)this.innerModel())).properties() == null) {
            return null;
        }
        return ((VaultInner)((Object)this.innerModel())).properties().vaultUri();
    }

    @Override
    public String tenantId() {
        if (((VaultInner)((Object)this.innerModel())).properties() == null) {
            return null;
        }
        if (((VaultInner)((Object)this.innerModel())).properties().tenantId() == null) {
            return null;
        }
        return ((VaultInner)((Object)this.innerModel())).properties().tenantId().toString();
    }

    @Override
    public Sku sku() {
        if (((VaultInner)((Object)this.innerModel())).properties() == null) {
            return null;
        }
        return ((VaultInner)((Object)this.innerModel())).properties().sku();
    }

    @Override
    public List<AccessPolicy> accessPolicies() {
        AccessPolicy[] array = new AccessPolicy[this.accessPolicies.size()];
        return Arrays.asList(this.accessPolicies.toArray(array));
    }

    @Override
    public boolean roleBasedAccessControlEnabled() {
        if (((VaultInner)((Object)this.innerModel())).properties() == null) {
            return false;
        }
        return ResourceManagerUtils.toPrimitiveBoolean((Boolean)((VaultInner)((Object)this.innerModel())).properties().enableRbacAuthorization());
    }

    @Override
    public boolean enabledForDeployment() {
        if (((VaultInner)((Object)this.innerModel())).properties() == null) {
            return false;
        }
        return ResourceManagerUtils.toPrimitiveBoolean((Boolean)((VaultInner)((Object)this.innerModel())).properties().enabledForDeployment());
    }

    @Override
    public boolean enabledForDiskEncryption() {
        if (((VaultInner)((Object)this.innerModel())).properties() == null) {
            return false;
        }
        return ResourceManagerUtils.toPrimitiveBoolean((Boolean)((VaultInner)((Object)this.innerModel())).properties().enabledForDiskEncryption());
    }

    @Override
    public boolean enabledForTemplateDeployment() {
        if (((VaultInner)((Object)this.innerModel())).properties() == null) {
            return false;
        }
        return ResourceManagerUtils.toPrimitiveBoolean((Boolean)((VaultInner)((Object)this.innerModel())).properties().enabledForTemplateDeployment());
    }

    @Override
    public boolean softDeleteEnabled() {
        if (((VaultInner)((Object)this.innerModel())).properties() == null) {
            return false;
        }
        return ResourceManagerUtils.toPrimitiveBoolean((Boolean)((VaultInner)((Object)this.innerModel())).properties().enableSoftDelete());
    }

    @Override
    public boolean purgeProtectionEnabled() {
        if (((VaultInner)((Object)this.innerModel())).properties() == null) {
            return false;
        }
        return ResourceManagerUtils.toPrimitiveBoolean((Boolean)((VaultInner)((Object)this.innerModel())).properties().enablePurgeProtection());
    }

    @Override
    public VaultImpl withEmptyAccessPolicy() {
        this.accessPolicies = new ArrayList<AccessPolicyImpl>();
        return this;
    }

    @Override
    public VaultImpl withoutAccessPolicy(String objectId) {
        for (AccessPolicyImpl entry : this.accessPolicies) {
            if (!entry.objectId().equals(objectId)) continue;
            this.accessPolicies.remove(entry);
            break;
        }
        return this;
    }

    @Override
    public VaultImpl withAccessPolicy(AccessPolicy accessPolicy) {
        this.accessPolicies.add((AccessPolicyImpl)accessPolicy);
        return this;
    }

    public AccessPolicyImpl defineAccessPolicy() {
        return new AccessPolicyImpl(new AccessPolicyEntry(), this);
    }

    @Override
    public VaultImpl withRoleBasedAccessControl() {
        ((VaultInner)((Object)this.innerModel())).properties().withEnableRbacAuthorization(true);
        return this;
    }

    @Override
    public VaultImpl withoutRoleBasedAccessControl() {
        ((VaultInner)((Object)this.innerModel())).properties().withEnableRbacAuthorization(false);
        return this;
    }

    @Override
    public AccessPolicyImpl updateAccessPolicy(String objectId) {
        for (AccessPolicyImpl entry : this.accessPolicies) {
            if (!entry.objectId().equals(objectId)) continue;
            return entry;
        }
        throw this.logger.logExceptionAsError((RuntimeException)new NoSuchElementException(String.format("Identity %s not found in the access policies.", objectId)));
    }

    @Override
    public VaultImpl withDeploymentEnabled() {
        ((VaultInner)((Object)this.innerModel())).properties().withEnabledForDeployment(true);
        return this;
    }

    @Override
    public VaultImpl withDiskEncryptionEnabled() {
        ((VaultInner)((Object)this.innerModel())).properties().withEnabledForDiskEncryption(true);
        return this;
    }

    @Override
    public VaultImpl withTemplateDeploymentEnabled() {
        ((VaultInner)((Object)this.innerModel())).properties().withEnabledForTemplateDeployment(true);
        return this;
    }

    @Override
    public VaultImpl withSoftDeleteEnabled() {
        ((VaultInner)((Object)this.innerModel())).properties().withEnableSoftDelete(true);
        return this;
    }

    @Override
    public VaultImpl withPurgeProtectionEnabled() {
        ((VaultInner)((Object)this.innerModel())).properties().withEnablePurgeProtection(true);
        return this;
    }

    @Override
    public VaultImpl withDeploymentDisabled() {
        ((VaultInner)((Object)this.innerModel())).properties().withEnabledForDeployment(false);
        return this;
    }

    @Override
    public VaultImpl withDiskEncryptionDisabled() {
        ((VaultInner)((Object)this.innerModel())).properties().withEnabledForDiskEncryption(false);
        return this;
    }

    @Override
    public VaultImpl withTemplateDeploymentDisabled() {
        ((VaultInner)((Object)this.innerModel())).properties().withEnabledForTemplateDeployment(false);
        return this;
    }

    @Override
    public VaultImpl withSku(SkuName skuName) {
        if (((VaultInner)((Object)this.innerModel())).properties() == null) {
            ((VaultInner)((Object)this.innerModel())).withProperties(new VaultProperties());
        }
        ((VaultInner)((Object)this.innerModel())).properties().withSku(new Sku().withName(skuName).withFamily(SkuFamily.A));
        return this;
    }

    private Mono<List<AccessPolicy>> populateAccessPolicies() {
        ArrayList<Mono> observables = new ArrayList<Mono>();
        for (AccessPolicyImpl accessPolicy : this.accessPolicies) {
            if (accessPolicy.objectId() != null) continue;
            if (accessPolicy.userPrincipalName() != null) {
                observables.add(this.authorizationManager.users().getByNameAsync(accessPolicy.userPrincipalName()).subscribeOn(ResourceManagerUtils.InternalRuntimeContext.getReactorScheduler()).doOnNext(user -> accessPolicy.forObjectId(user.id())).switchIfEmpty(Mono.error((Throwable)new ManagementException(String.format("User principal name %s is not found in tenant %s", accessPolicy.userPrincipalName(), this.authorizationManager.tenantId()), null))));
                continue;
            }
            if (accessPolicy.servicePrincipalName() != null) {
                observables.add(this.authorizationManager.servicePrincipals().getByNameAsync(accessPolicy.servicePrincipalName()).subscribeOn(ResourceManagerUtils.InternalRuntimeContext.getReactorScheduler()).doOnNext(sp -> accessPolicy.forObjectId(sp.id())).switchIfEmpty(Mono.error((Throwable)new ManagementException(String.format("Service principal name %s is not found in tenant %s", accessPolicy.servicePrincipalName(), this.authorizationManager.tenantId()), null))));
                continue;
            }
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Access policy must specify object ID."));
        }
        if (observables.isEmpty()) {
            return Mono.just(this.accessPolicies());
        }
        return Mono.zip(observables, args -> this.accessPolicies());
    }

    public Mono<Vault> createResourceAsync() {
        VaultsClient client = ((KeyVaultManagementClient)((KeyVaultManager)this.manager()).serviceClient()).getVaults();
        return this.populateAccessPolicies().then(Mono.defer(() -> {
            VaultCreateOrUpdateParameters parameters = new VaultCreateOrUpdateParameters();
            parameters.withLocation(this.regionName());
            parameters.withProperties(((VaultInner)((Object)((Object)this.innerModel()))).properties());
            parameters.withTags(((VaultInner)((Object)((Object)this.innerModel()))).tags());
            parameters.properties().withAccessPolicies(new ArrayList<AccessPolicyEntry>());
            for (AccessPolicy accessPolicy : this.accessPolicies) {
                parameters.properties().accessPolicies().add((AccessPolicyEntry)accessPolicy.innerModel());
            }
            return client.createOrUpdateAsync(this.resourceGroupName(), this.name(), parameters);
        })).map(inner -> {
            this.setInner(inner);
            this.init();
            return this;
        });
    }

    protected Mono<VaultInner> getInnerAsync() {
        return ((KeyVaultManagementClient)((KeyVaultManager)this.manager()).serviceClient()).getVaults().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public CreateMode createMode() {
        return ((VaultInner)((Object)this.innerModel())).properties().createMode();
    }

    @Override
    public NetworkRuleSet networkRuleSet() {
        return ((VaultInner)((Object)this.innerModel())).properties().networkAcls();
    }

    @Override
    public VaultImpl withAccessFromAllNetworks() {
        if (((VaultInner)((Object)this.innerModel())).properties().networkAcls() == null) {
            ((VaultInner)((Object)this.innerModel())).properties().withNetworkAcls(new NetworkRuleSet());
        }
        ((VaultInner)((Object)this.innerModel())).properties().networkAcls().withDefaultAction(NetworkRuleAction.ALLOW);
        return this;
    }

    @Override
    public VaultImpl withAccessFromSelectedNetworks() {
        if (((VaultInner)((Object)this.innerModel())).properties().networkAcls() == null) {
            ((VaultInner)((Object)this.innerModel())).properties().withNetworkAcls(new NetworkRuleSet());
        }
        ((VaultInner)((Object)this.innerModel())).properties().networkAcls().withDefaultAction(NetworkRuleAction.DENY);
        return this;
    }

    private VaultImpl withAccessAllowedFromIpAddressOrRange(String ipAddressOrRange) {
        NetworkRuleSet networkRuleSet = ((VaultInner)((Object)this.innerModel())).properties().networkAcls();
        if (networkRuleSet.ipRules() == null) {
            networkRuleSet.withIpRules(new ArrayList<IpRule>());
        }
        boolean found = false;
        for (IpRule rule : networkRuleSet.ipRules()) {
            if (!rule.value().equalsIgnoreCase(ipAddressOrRange)) continue;
            found = true;
            break;
        }
        if (!found) {
            networkRuleSet.ipRules().add(new IpRule().withValue(ipAddressOrRange));
        }
        return this;
    }

    @Override
    public VaultImpl withAccessFromIpAddress(String ipAddress) {
        return this.withAccessAllowedFromIpAddressOrRange(ipAddress);
    }

    @Override
    public VaultImpl withAccessFromIpAddressRange(String ipAddressCidr) {
        return this.withAccessAllowedFromIpAddressOrRange(ipAddressCidr);
    }

    @Override
    public VaultImpl withAccessFromAzureServices() {
        if (((VaultInner)((Object)this.innerModel())).properties().networkAcls() == null) {
            ((VaultInner)((Object)this.innerModel())).properties().withNetworkAcls(new NetworkRuleSet());
        }
        ((VaultInner)((Object)this.innerModel())).properties().networkAcls().withBypass(NetworkRuleBypassOptions.AZURE_SERVICES);
        return this;
    }

    @Override
    public VaultImpl withBypass(NetworkRuleBypassOptions bypass) {
        if (((VaultInner)((Object)this.innerModel())).properties().networkAcls() == null) {
            ((VaultInner)((Object)this.innerModel())).properties().withNetworkAcls(new NetworkRuleSet());
        }
        ((VaultInner)((Object)this.innerModel())).properties().networkAcls().withBypass(bypass);
        return this;
    }

    @Override
    public VaultImpl withDefaultAction(NetworkRuleAction defaultAction) {
        if (((VaultInner)((Object)this.innerModel())).properties().networkAcls() == null) {
            ((VaultInner)((Object)this.innerModel())).properties().withNetworkAcls(new NetworkRuleSet());
        }
        ((VaultInner)((Object)this.innerModel())).properties().networkAcls().withDefaultAction(defaultAction);
        return this;
    }

    @Override
    public VaultImpl withVirtualNetworkRules(List<VirtualNetworkRule> virtualNetworkRules) {
        if (((VaultInner)((Object)this.innerModel())).properties().networkAcls() == null) {
            ((VaultInner)((Object)this.innerModel())).properties().withNetworkAcls(new NetworkRuleSet());
        }
        ((VaultInner)((Object)this.innerModel())).properties().networkAcls().withVirtualNetworkRules(virtualNetworkRules);
        return this;
    }

    public PagedIterable<com.azure.resourcemanager.resources.fluentcore.arm.models.PrivateLinkResource> listPrivateLinkResources() {
        return new PagedIterable(this.listPrivateLinkResourcesAsync());
    }

    public PagedFlux<com.azure.resourcemanager.resources.fluentcore.arm.models.PrivateLinkResource> listPrivateLinkResourcesAsync() {
        Mono retList = ((KeyVaultManagementClient)((KeyVaultManager)this.manager()).serviceClient()).getPrivateLinkResources().listByVaultWithResponseAsync(this.resourceGroupName(), this.name()).map(response -> new SimpleResponse(response, ((PrivateLinkResourceListResultInner)response.getValue()).value().stream().map(x$0 -> new PrivateLinkResourceImpl((PrivateLinkResource)((Object)((Object)x$0)))).collect(Collectors.toList())));
        return PagedConverter.convertListToPagedFlux((Mono)retList);
    }

    public void approvePrivateEndpointConnection(String privateEndpointConnectionName) {
        this.approvePrivateEndpointConnectionAsync(privateEndpointConnectionName).block();
    }

    public Mono<Void> approvePrivateEndpointConnectionAsync(String privateEndpointConnectionName) {
        return ((KeyVaultManagementClient)((KeyVaultManager)this.manager()).serviceClient()).getPrivateEndpointConnections().putAsync(this.resourceGroupName(), this.name(), privateEndpointConnectionName, new PrivateEndpointConnectionInner().withPrivateLinkServiceConnectionState(new PrivateLinkServiceConnectionState().withStatus(PrivateEndpointServiceConnectionStatus.APPROVED))).then();
    }

    public void rejectPrivateEndpointConnection(String privateEndpointConnectionName) {
        this.rejectPrivateEndpointConnectionAsync(privateEndpointConnectionName).block();
    }

    public Mono<Void> rejectPrivateEndpointConnectionAsync(String privateEndpointConnectionName) {
        return ((KeyVaultManagementClient)((KeyVaultManager)this.manager()).serviceClient()).getPrivateEndpointConnections().putAsync(this.resourceGroupName(), this.name(), privateEndpointConnectionName, new PrivateEndpointConnectionInner().withPrivateLinkServiceConnectionState(new PrivateLinkServiceConnectionState().withStatus(PrivateEndpointServiceConnectionStatus.REJECTED))).then();
    }

    private static final class PrivateLinkResourceImpl
    implements com.azure.resourcemanager.resources.fluentcore.arm.models.PrivateLinkResource {
        private final PrivateLinkResource innerModel;

        private PrivateLinkResourceImpl(PrivateLinkResource innerModel) {
            this.innerModel = innerModel;
        }

        public String groupId() {
            return this.innerModel.groupId();
        }

        public List<String> requiredMemberNames() {
            return Collections.unmodifiableList(this.innerModel.requiredMembers());
        }

        public List<String> requiredDnsZoneNames() {
            return Collections.unmodifiableList(this.innerModel.requiredZoneNames());
        }
    }
}

