/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.keyvault.implementation;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.management.Resource;
import com.azure.resourcemanager.keyvault.KeyVaultManager;
import com.azure.resourcemanager.keyvault.fluent.KeyVaultManagementClient;
import com.azure.resourcemanager.keyvault.fluent.models.ManagedHsmInner;
import com.azure.resourcemanager.keyvault.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.keyvault.fluent.models.PrivateLinkResourceListResultInner;
import com.azure.resourcemanager.keyvault.implementation.KeysImpl;
import com.azure.resourcemanager.keyvault.models.Keys;
import com.azure.resourcemanager.keyvault.models.ManagedHsm;
import com.azure.resourcemanager.keyvault.models.ManagedHsmSku;
import com.azure.resourcemanager.keyvault.models.MhsmNetworkRuleSet;
import com.azure.resourcemanager.keyvault.models.PrivateEndpointServiceConnectionStatus;
import com.azure.resourcemanager.keyvault.models.PrivateLinkServiceConnectionState;
import com.azure.resourcemanager.keyvault.models.PublicNetworkAccess;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.models.PrivateLinkResource;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.azure.security.keyvault.keys.KeyAsyncClient;
import com.azure.security.keyvault.keys.KeyClientBuilder;
import com.azure.security.keyvault.keys.KeyServiceVersion;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

class ManagedHsmImpl
extends GroupableResourceImpl<ManagedHsm, ManagedHsmInner, ManagedHsmImpl, KeyVaultManager>
implements ManagedHsm {
    private KeyAsyncClient keyClient;
    private final HttpPipeline mhsmHttpPipeline = ((KeyVaultManager)this.manager()).httpPipeline();

    ManagedHsmImpl(String name, ManagedHsmInner innerObject, KeyVaultManager manager) {
        super(name, (Resource)innerObject, (Manager)manager);
        if (((ManagedHsmInner)((Object)this.innerModel())).properties() != null && ((ManagedHsmInner)((Object)this.innerModel())).properties().hsmUri() != null) {
            this.keyClient = new KeyClientBuilder().pipeline(this.mhsmHttpPipeline).vaultUrl(((ManagedHsmInner)((Object)this.innerModel())).properties().hsmUri()).serviceVersion(KeyServiceVersion.V7_2).buildAsyncClient();
        }
    }

    public Mono<ManagedHsm> createResourceAsync() {
        throw new UnsupportedOperationException("method [createResourceAsync] not implemented in class [com.azure.resourcemanager.keyvault.implementation.ManagedHsmImpl]");
    }

    protected Mono<ManagedHsmInner> getInnerAsync() {
        return ((KeyVaultManagementClient)((KeyVaultManager)this.manager()).serviceClient()).getManagedHsms().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public String tenantId() {
        if (((ManagedHsmInner)((Object)this.innerModel())).properties() == null || ((ManagedHsmInner)((Object)this.innerModel())).properties().tenantId() == null) {
            return null;
        }
        return ((ManagedHsmInner)((Object)this.innerModel())).properties().tenantId().toString();
    }

    @Override
    public ManagedHsmSku sku() {
        return ((ManagedHsmInner)((Object)this.innerModel())).sku();
    }

    @Override
    public List<String> initialAdminObjectIds() {
        if (((ManagedHsmInner)((Object)this.innerModel())).properties() == null || ((ManagedHsmInner)((Object)this.innerModel())).properties().initialAdminObjectIds() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(((ManagedHsmInner)((Object)this.innerModel())).properties().initialAdminObjectIds());
    }

    @Override
    public String hsmUri() {
        if (((ManagedHsmInner)((Object)this.innerModel())).properties() == null) {
            return null;
        }
        return ((ManagedHsmInner)((Object)this.innerModel())).properties().hsmUri();
    }

    @Override
    public boolean isSoftDeleteEnabled() {
        if (((ManagedHsmInner)((Object)this.innerModel())).properties() == null) {
            return false;
        }
        return ResourceManagerUtils.toPrimitiveBoolean((Boolean)((ManagedHsmInner)((Object)this.innerModel())).properties().enableSoftDelete());
    }

    @Override
    public Integer softDeleteRetentionInDays() {
        if (((ManagedHsmInner)((Object)this.innerModel())).properties() == null) {
            return null;
        }
        return ((ManagedHsmInner)((Object)this.innerModel())).properties().softDeleteRetentionInDays();
    }

    @Override
    public boolean isPurgeProtectionEnabled() {
        if (((ManagedHsmInner)((Object)this.innerModel())).properties() == null) {
            return false;
        }
        return ResourceManagerUtils.toPrimitiveBoolean((Boolean)((ManagedHsmInner)((Object)this.innerModel())).properties().enablePurgeProtection());
    }

    @Override
    public MhsmNetworkRuleSet networkRuleSet() {
        if (((ManagedHsmInner)((Object)this.innerModel())).properties() == null) {
            return null;
        }
        return ((ManagedHsmInner)((Object)this.innerModel())).properties().networkAcls();
    }

    @Override
    public Keys keys() {
        return new KeysImpl(this.keyClient, this.mhsmHttpPipeline);
    }

    @Override
    public OffsetDateTime scheduledPurgeDate() {
        if (((ManagedHsmInner)((Object)this.innerModel())).properties() == null) {
            return null;
        }
        return ((ManagedHsmInner)((Object)this.innerModel())).properties().scheduledPurgeDate();
    }

    @Override
    public PublicNetworkAccess publicNetworkAccess() {
        if (((ManagedHsmInner)((Object)this.innerModel())).properties() == null) {
            return null;
        }
        return ((ManagedHsmInner)((Object)this.innerModel())).properties().publicNetworkAccess();
    }

    public PagedIterable<PrivateLinkResource> listPrivateLinkResources() {
        return new PagedIterable(this.listPrivateLinkResourcesAsync());
    }

    public PagedFlux<PrivateLinkResource> listPrivateLinkResourcesAsync() {
        Mono retList = ((KeyVaultManagementClient)((KeyVaultManager)this.manager()).serviceClient()).getPrivateLinkResources().listByVaultWithResponseAsync(this.resourceGroupName(), this.name()).map(response -> new SimpleResponse(response, ((PrivateLinkResourceListResultInner)response.getValue()).value().stream().map(x$0 -> new PrivateLinkResourceImpl((com.azure.resourcemanager.keyvault.models.PrivateLinkResource)((Object)((Object)x$0)))).collect(Collectors.toList())));
        return PagedConverter.convertListToPagedFlux((Mono)retList);
    }

    public void approvePrivateEndpointConnection(String privateEndpointConnectionName) {
        this.approvePrivateEndpointConnectionAsync(privateEndpointConnectionName).block();
    }

    public Mono<Void> approvePrivateEndpointConnectionAsync(String privateEndpointConnectionName) {
        return ((KeyVaultManagementClient)((KeyVaultManager)this.manager()).serviceClient()).getPrivateEndpointConnections().putAsync(this.resourceGroupName(), this.name(), privateEndpointConnectionName, new PrivateEndpointConnectionInner().withPrivateLinkServiceConnectionState(new PrivateLinkServiceConnectionState().withStatus(PrivateEndpointServiceConnectionStatus.APPROVED))).then();
    }

    public void rejectPrivateEndpointConnection(String privateEndpointConnectionName) {
        this.rejectPrivateEndpointConnectionAsync(privateEndpointConnectionName).block();
    }

    public Mono<Void> rejectPrivateEndpointConnectionAsync(String privateEndpointConnectionName) {
        return ((KeyVaultManagementClient)((KeyVaultManager)this.manager()).serviceClient()).getPrivateEndpointConnections().putAsync(this.resourceGroupName(), this.name(), privateEndpointConnectionName, new PrivateEndpointConnectionInner().withPrivateLinkServiceConnectionState(new PrivateLinkServiceConnectionState().withStatus(PrivateEndpointServiceConnectionStatus.REJECTED))).then();
    }

    private static final class PrivateLinkResourceImpl
    implements PrivateLinkResource {
        private final com.azure.resourcemanager.keyvault.models.PrivateLinkResource innerModel;

        private PrivateLinkResourceImpl(com.azure.resourcemanager.keyvault.models.PrivateLinkResource innerModel) {
            this.innerModel = innerModel;
        }

        public String groupId() {
            return this.innerModel.groupId();
        }

        public List<String> requiredMemberNames() {
            return Collections.unmodifiableList(this.innerModel.requiredMembers());
        }

        public List<String> requiredDnsZoneNames() {
            return Collections.unmodifiableList(this.innerModel.requiredZoneNames());
        }
    }
}

