// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.keyvault.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.management.exception.ManagementError;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The error exception. */
@Immutable
public final class Error extends ManagementError {
    /*
     * The inner error, contains a more specific error code.
     */
    @JsonProperty(value = "innererror", access = JsonProperty.Access.WRITE_ONLY)
    private Error innerError;

    /**
     * Get the innerError property: The inner error, contains a more specific error code.
     *
     * @return the innerError value.
     */
    public Error getInnerError() {
        return this.innerError;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (getInnerError() != null) {
            getInnerError().validate();
        }
    }
}
