/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventhubs.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.eventhubs.EventHubsManager;
import com.azure.resourcemanager.eventhubs.fluent.EventHubManagementClient;
import com.azure.resourcemanager.eventhubs.fluent.models.EventhubInner;
import com.azure.resourcemanager.eventhubs.implementation.Ancestors;
import com.azure.resourcemanager.eventhubs.implementation.EventHubNamespaceImpl;
import com.azure.resourcemanager.eventhubs.implementation.NestedResourceImpl;
import com.azure.resourcemanager.eventhubs.models.CaptureDescription;
import com.azure.resourcemanager.eventhubs.models.Destination;
import com.azure.resourcemanager.eventhubs.models.EncodingCaptureDescription;
import com.azure.resourcemanager.eventhubs.models.EventHub;
import com.azure.resourcemanager.eventhubs.models.EventHubAuthorizationRule;
import com.azure.resourcemanager.eventhubs.models.EventHubConsumerGroup;
import com.azure.resourcemanager.eventhubs.models.EventHubNamespace;
import com.azure.resourcemanager.resources.fluentcore.dag.VoidIndexable;
import com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.azure.resourcemanager.resources.fluentcore.model.Indexable;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.azure.resourcemanager.storage.StorageManager;
import com.azure.resourcemanager.storage.models.PublicAccess;
import com.azure.resourcemanager.storage.models.StorageAccount;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class EventHubImpl
extends NestedResourceImpl<EventHub, EventhubInner, EventHubImpl>
implements EventHub,
EventHub.Definition,
EventHub.Update {
    private Ancestors.OneAncestor ancestor;
    private CaptureSettings captureSettings;
    private StorageManager storageManager;
    private Flux<Indexable> postRunTasks;
    private final ClientLogger logger = new ClientLogger(EventHubImpl.class);

    EventHubImpl(String name, EventhubInner inner, EventHubsManager manager, StorageManager storageManager) {
        super(name, inner, manager);
        this.ancestor = new Ancestors().new Ancestors.OneAncestor(inner.id());
        this.captureSettings = new CaptureSettings((EventhubInner)((Object)this.innerModel()));
        this.storageManager = storageManager;
    }

    EventHubImpl(String name, EventHubsManager manager, StorageManager storageManager) {
        super(name, new EventhubInner(), manager);
        this.storageManager = storageManager;
        this.captureSettings = new CaptureSettings((EventhubInner)((Object)this.innerModel()));
    }

    @Override
    public String namespaceResourceGroupName() {
        return this.ancestor().resourceGroupName();
    }

    @Override
    public String namespaceName() {
        return this.ancestor().ancestor1Name();
    }

    @Override
    public boolean isDataCaptureEnabled() {
        if (((EventhubInner)((Object)this.innerModel())).captureDescription() == null) {
            return false;
        }
        return ResourceManagerUtils.toPrimitiveBoolean((Boolean)((EventhubInner)((Object)this.innerModel())).captureDescription().enabled());
    }

    @Override
    public int dataCaptureWindowSizeInSeconds() {
        if (((EventhubInner)((Object)this.innerModel())).captureDescription() == null) {
            return 0;
        }
        return ResourceManagerUtils.toPrimitiveInt((Integer)((EventhubInner)((Object)this.innerModel())).captureDescription().intervalInSeconds());
    }

    @Override
    public int dataCaptureWindowSizeInMB() {
        if (((EventhubInner)((Object)this.innerModel())).captureDescription() == null) {
            return 0;
        }
        int inBytes = ResourceManagerUtils.toPrimitiveInt((Integer)((EventhubInner)((Object)this.innerModel())).captureDescription().sizeLimitInBytes());
        if (inBytes != 0) {
            return inBytes / 0x100000;
        }
        return 0;
    }

    @Override
    public boolean dataCaptureSkipEmptyArchives() {
        if (((EventhubInner)((Object)this.innerModel())).captureDescription() == null) {
            return false;
        }
        return ((EventhubInner)((Object)this.innerModel())).captureDescription().skipEmptyArchives();
    }

    @Override
    public String dataCaptureFileNameFormat() {
        if (((EventhubInner)((Object)this.innerModel())).captureDescription() == null) {
            return null;
        }
        if (((EventhubInner)((Object)this.innerModel())).captureDescription().destination() == null) {
            return null;
        }
        return ((EventhubInner)((Object)this.innerModel())).captureDescription().destination().archiveNameFormat();
    }

    @Override
    public Destination captureDestination() {
        if (((EventhubInner)((Object)this.innerModel())).captureDescription() == null) {
            return null;
        }
        return ((EventhubInner)((Object)this.innerModel())).captureDescription().destination();
    }

    @Override
    public Set<String> partitionIds() {
        if (((EventhubInner)((Object)this.innerModel())).partitionIds() == null) {
            return Collections.unmodifiableSet(new HashSet());
        }
        return Collections.unmodifiableSet(new HashSet<String>(((EventhubInner)((Object)this.innerModel())).partitionIds()));
    }

    @Override
    public int messageRetentionPeriodInDays() {
        return ResourceManagerUtils.toPrimitiveInt((Long)((EventhubInner)((Object)this.innerModel())).messageRetentionInDays());
    }

    @Override
    public EventHubImpl withNewNamespace(Creatable<EventHubNamespace> namespaceCreatable) {
        this.addDependency(namespaceCreatable);
        if (namespaceCreatable instanceof EventHubNamespaceImpl) {
            EventHubNamespaceImpl namespace = (EventHubNamespaceImpl)namespaceCreatable;
            this.ancestor = new Ancestors().new Ancestors.OneAncestor(namespace.resourceGroupName(), namespaceCreatable.name());
        } else {
            this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("The namespaceCreatable is invalid."));
        }
        return this;
    }

    @Override
    public EventHubImpl withExistingNamespace(EventHubNamespace namespace) {
        this.ancestor = new Ancestors().new Ancestors.OneAncestor(this.selfId(namespace.id()));
        return this;
    }

    @Override
    public EventHubImpl withExistingNamespace(String resourceGroupName, String namespaceName) {
        this.ancestor = new Ancestors().new Ancestors.OneAncestor(resourceGroupName, namespaceName);
        return this;
    }

    @Override
    public EventHubImpl withExistingNamespaceId(String namespaceId) {
        this.ancestor = new Ancestors().new Ancestors.OneAncestor(this.selfId(namespaceId));
        return this;
    }

    @Override
    public EventHubImpl withNewStorageAccountForCapturedData(Creatable<StorageAccount> storageAccountCreatable, String containerName) {
        this.captureSettings.withNewStorageAccountForCapturedData(storageAccountCreatable, containerName);
        return this;
    }

    @Override
    public EventHubImpl withExistingStorageAccountForCapturedData(StorageAccount storageAccount, String containerName) {
        this.captureSettings.withExistingStorageAccountForCapturedData(storageAccount, containerName);
        return this;
    }

    @Override
    public EventHubImpl withExistingStorageAccountForCapturedData(String storageAccountId, String containerName) {
        this.captureSettings.withExistingStorageAccountForCapturedData(storageAccountId, containerName);
        return this;
    }

    @Override
    public EventHubImpl withDataCaptureEnabled() {
        this.captureSettings.withDataCaptureEnabled();
        return this;
    }

    @Override
    public EventHubImpl withDataCaptureDisabled() {
        this.captureSettings.withDataCaptureDisabled();
        return this;
    }

    @Override
    public EventHubImpl withDataCaptureWindowSizeInSeconds(int sizeInSeconds) {
        this.captureSettings.withDataCaptureWindowSizeInSeconds(sizeInSeconds);
        return this;
    }

    @Override
    public EventHubImpl withDataCaptureSkipEmptyArchives(Boolean skipEmptyArchives) {
        this.captureSettings.withDataCaptureSkipEmptyArchives(skipEmptyArchives);
        return this;
    }

    @Override
    public EventHubImpl withDataCaptureWindowSizeInMB(int sizeInMB) {
        this.captureSettings.withDataCaptureWindowSizeInMB(sizeInMB);
        return this;
    }

    @Override
    public EventHubImpl withDataCaptureFileNameFormat(String format) {
        this.captureSettings.withDataCaptureFileNameFormat(format);
        return this;
    }

    @Override
    public EventHubImpl withNewSendRule(String ruleName) {
        this.concatPostRunTask((Mono<Indexable>)((EventHubAuthorizationRule.DefinitionStages.WithCreate)((EventHubAuthorizationRule.DefinitionStages.Blank)this.manager().eventHubAuthorizationRules().define(ruleName)).withExistingEventHub(this.ancestor().resourceGroupName(), this.ancestor().ancestor1Name(), this.name()).withSendAccess()).createAsync().cast(Indexable.class));
        return this;
    }

    @Override
    public EventHubImpl withNewListenRule(String ruleName) {
        this.concatPostRunTask((Mono<Indexable>)((EventHubAuthorizationRule.DefinitionStages.WithCreate)((EventHubAuthorizationRule.DefinitionStages.Blank)this.manager().eventHubAuthorizationRules().define(ruleName)).withExistingEventHub(this.ancestor().resourceGroupName(), this.ancestor().ancestor1Name(), this.name()).withListenAccess()).createAsync().cast(Indexable.class));
        return this;
    }

    @Override
    public EventHubImpl withNewSendAndListenRule(String ruleName) {
        this.concatPostRunTask((Mono<Indexable>)((EventHubAuthorizationRule.DefinitionStages.WithCreate)((EventHubAuthorizationRule.DefinitionStages.Blank)this.manager().eventHubAuthorizationRules().define(ruleName)).withExistingEventHub(this.ancestor().resourceGroupName(), this.ancestor().ancestor1Name(), this.name()).withSendAndListenAccess()).createAsync().cast(Indexable.class));
        return this;
    }

    @Override
    public EventHubImpl withNewManageRule(String ruleName) {
        this.concatPostRunTask((Mono<Indexable>)((EventHubAuthorizationRule.DefinitionStages.WithCreate)((EventHubAuthorizationRule.DefinitionStages.Blank)this.manager().eventHubAuthorizationRules().define(ruleName)).withExistingEventHub(this.ancestor().resourceGroupName(), this.ancestor().ancestor1Name(), this.name()).withManageAccess()).createAsync().cast(Indexable.class));
        return this;
    }

    @Override
    public EventHubImpl withoutAuthorizationRule(String ruleName) {
        this.concatPostRunTask((Mono<Indexable>)this.manager().eventHubAuthorizationRules().deleteByNameAsync(this.ancestor().resourceGroupName(), this.ancestor().ancestor1Name(), this.name(), ruleName).map(aVoid -> new VoidIndexable(UUID.randomUUID().toString())));
        return this;
    }

    @Override
    public EventHubImpl withNewConsumerGroup(String name) {
        this.concatPostRunTask((Mono<Indexable>)((EventHubConsumerGroup.DefinitionStages.Blank)this.manager().consumerGroups().define(name)).withExistingEventHub(this.ancestor().resourceGroupName(), this.ancestor().ancestor1Name(), this.name()).createAsync().cast(Indexable.class));
        return this;
    }

    @Override
    public EventHubImpl withNewConsumerGroup(String name, String metadata) {
        this.concatPostRunTask((Mono<Indexable>)((EventHubConsumerGroup.DefinitionStages.Blank)this.manager().consumerGroups().define(name)).withExistingEventHub(this.ancestor().resourceGroupName(), this.ancestor().ancestor1Name(), this.name()).withUserMetadata(metadata).createAsync().cast(Indexable.class));
        return this;
    }

    @Override
    public EventHubImpl withoutConsumerGroup(String name) {
        this.concatPostRunTask((Mono<Indexable>)this.manager().consumerGroups().deleteByNameAsync(this.ancestor().resourceGroupName(), this.ancestor().ancestor1Name(), this.name(), name).map(aVoid -> new VoidIndexable(UUID.randomUUID().toString())));
        return this;
    }

    @Override
    public EventHubImpl withPartitionCount(long count) {
        ((EventhubInner)((Object)this.innerModel())).withPartitionCount(count);
        return this;
    }

    @Override
    public EventHubImpl withRetentionPeriodInDays(long period) {
        ((EventhubInner)((Object)this.innerModel())).withMessageRetentionInDays(period);
        return this;
    }

    public EventHubImpl update() {
        this.captureSettings = new CaptureSettings((EventhubInner)((Object)this.innerModel()));
        return (EventHubImpl)super.update();
    }

    public void beforeGroupCreateOrUpdate() {
        if (this.postRunTasks != null) {
            this.addPostRunDependent(context -> this.postRunTasks.last());
        }
        ((EventhubInner)((Object)this.innerModel())).withCaptureDescription(this.captureSettings.validateAndGetSettings());
    }

    public Mono<EventHub> createResourceAsync() {
        return ((EventHubManagementClient)this.manager.serviceClient()).getEventHubs().createOrUpdateAsync(this.ancestor().resourceGroupName(), this.ancestor().ancestor1Name(), this.name(), (EventhubInner)((Object)this.innerModel())).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    public Mono<Void> afterPostRunAsync(boolean isGroupFaulted) {
        this.postRunTasks = null;
        return Mono.empty();
    }

    protected Mono<EventhubInner> getInnerAsync() {
        return ((EventHubManagementClient)this.manager.serviceClient()).getEventHubs().getAsync(this.ancestor().resourceGroupName(), this.ancestor().ancestor1Name(), this.name());
    }

    @Override
    public PagedFlux<EventHubConsumerGroup> listConsumerGroupsAsync() {
        return this.manager.consumerGroups().listByEventHubAsync(this.ancestor().resourceGroupName(), this.ancestor().ancestor1Name(), this.name());
    }

    @Override
    public PagedFlux<EventHubAuthorizationRule> listAuthorizationRulesAsync() {
        return this.manager.eventHubAuthorizationRules().listByEventHubAsync(this.ancestor().resourceGroupName(), this.ancestor().ancestor1Name(), this.name());
    }

    @Override
    public PagedIterable<EventHubConsumerGroup> listConsumerGroups() {
        return this.manager.consumerGroups().listByEventHub(this.ancestor().resourceGroupName(), this.ancestor().ancestor1Name(), this.name());
    }

    @Override
    public PagedIterable<EventHubAuthorizationRule> listAuthorizationRules() {
        return this.manager.eventHubAuthorizationRules().listByEventHub(this.ancestor().resourceGroupName(), this.ancestor().ancestor1Name(), this.name());
    }

    private Ancestors.OneAncestor ancestor() {
        Objects.requireNonNull(this.ancestor);
        return this.ancestor;
    }

    private String selfId(String parentId) {
        return String.format("%s/eventhubs/%s", parentId, this.name());
    }

    private void concatPostRunTask(Mono<Indexable> task) {
        if (this.postRunTasks == null) {
            this.postRunTasks = Flux.empty();
        }
        this.postRunTasks = this.postRunTasks.concatWith(task);
    }

    private class CaptureSettings {
        private final CaptureDescription currentSettings;
        private CaptureDescription newSettings;

        CaptureSettings(EventhubInner eventhubInner) {
            this.currentSettings = eventhubInner.captureDescription();
        }

        public CaptureSettings withNewStorageAccountForCapturedData(Creatable<StorageAccount> creatableStorageAccount, String containerName) {
            this.ensureSettings().destination().withStorageAccountResourceId("temp-id");
            this.ensureSettings().destination().withBlobContainer(containerName);
            EventHubImpl.this.addDependency(context -> creatableStorageAccount.createAsync().flatMap(indexable -> {
                StorageAccount storageAccount = indexable;
                this.ensureSettings().destination().withStorageAccountResourceId(storageAccount.id());
                return this.createContainerIfNotExistsAsync(storageAccount, containerName);
            }));
            return this;
        }

        public CaptureSettings withExistingStorageAccountForCapturedData(StorageAccount storageAccount, String containerName) {
            this.ensureSettings().destination().withStorageAccountResourceId(storageAccount.id());
            this.ensureSettings().destination().withBlobContainer(containerName);
            EventHubImpl.this.addDependency(context -> this.createContainerIfNotExistsAsync(storageAccount, containerName));
            return this;
        }

        public CaptureSettings withExistingStorageAccountForCapturedData(String storageAccountId, String containerName) {
            this.ensureSettings().destination().withStorageAccountResourceId(storageAccountId);
            this.ensureSettings().destination().withBlobContainer(containerName);
            EventHubImpl.this.addDependency(context -> EventHubImpl.this.storageManager.storageAccounts().getByIdAsync(storageAccountId).flatMap(storageAccount -> {
                this.ensureSettings().destination().withStorageAccountResourceId(storageAccount.id());
                return this.createContainerIfNotExistsAsync((StorageAccount)storageAccount, containerName);
            }));
            return this;
        }

        public CaptureSettings withDataCaptureEnabled() {
            this.ensureSettings().withEnabled(true);
            return this;
        }

        public CaptureSettings withDataCaptureDisabled() {
            this.ensureSettings().withEnabled(false);
            return this;
        }

        public CaptureSettings withDataCaptureSkipEmptyArchives(Boolean skipEmptyArchives) {
            this.ensureSettings().withSkipEmptyArchives(skipEmptyArchives);
            return this;
        }

        public CaptureSettings withDataCaptureWindowSizeInSeconds(int sizeInSeconds) {
            this.ensureSettings().withIntervalInSeconds(sizeInSeconds);
            return this;
        }

        public CaptureSettings withDataCaptureWindowSizeInMB(int sizeInMB) {
            this.ensureSettings().withSizeLimitInBytes(sizeInMB * 1024 * 1024);
            return this;
        }

        public CaptureSettings withDataCaptureFileNameFormat(String format) {
            this.ensureSettings().destination().withArchiveNameFormat(format);
            return this;
        }

        public CaptureDescription validateAndGetSettings() {
            if (this.newSettings == null) {
                return this.currentSettings;
            }
            if (this.newSettings.destination() == null || this.newSettings.destination().storageAccountResourceId() == null || this.newSettings.destination().blobContainer() == null) {
                throw EventHubImpl.this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("Setting any of the capture properties requires capture destination [StorageAccount, DataLake] to be specified"));
            }
            if (this.newSettings.destination().name() == null) {
                this.newSettings.destination().withName("EventHubArchive.AzureBlockBlob");
            }
            if (this.newSettings.encoding() == null) {
                this.newSettings.withEncoding(EncodingCaptureDescription.AVRO);
            }
            return this.newSettings;
        }

        private CaptureDescription ensureSettings() {
            if (this.newSettings != null) {
                return this.newSettings;
            }
            if (this.currentSettings == null) {
                this.newSettings = new CaptureDescription().withDestination(new Destination());
                return this.newSettings;
            }
            this.newSettings = this.cloneCurrentSettings();
            return this.newSettings;
        }

        private Mono<Indexable> createContainerIfNotExistsAsync(StorageAccount storageAccount, String containerName) {
            return EventHubImpl.this.storageManager.blobContainers().getAsync(storageAccount.resourceGroupName(), storageAccount.name(), containerName).cast(Indexable.class).onErrorResume(throwable -> EventHubImpl.this.storageManager.blobContainers().defineContainer(containerName).withExistingStorageAccount(storageAccount.resourceGroupName(), storageAccount.name()).withPublicAccess(PublicAccess.NONE).createAsync());
        }

        private CaptureDescription cloneCurrentSettings() {
            Objects.requireNonNull(this.currentSettings);
            CaptureDescription clone = new CaptureDescription();
            clone.withSizeLimitInBytes(this.currentSettings.sizeLimitInBytes());
            clone.withSkipEmptyArchives(this.currentSettings.skipEmptyArchives());
            clone.withIntervalInSeconds(this.currentSettings.intervalInSeconds());
            clone.withEnabled(this.currentSettings.enabled());
            clone.withEncoding(this.currentSettings.encoding());
            if (this.currentSettings.destination() != null) {
                clone.withDestination(new Destination());
                clone.destination().withArchiveNameFormat(this.currentSettings.destination().archiveNameFormat());
                clone.destination().withBlobContainer(this.currentSettings.destination().blobContainer());
                clone.destination().withName(this.currentSettings.destination().name());
                clone.destination().withStorageAccountResourceId(this.currentSettings.destination().storageAccountResourceId());
            } else {
                clone.withDestination(new Destination());
            }
            return clone;
        }
    }
}

