/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventhubs.models;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.resourcemanager.eventhubs.EventHubsManager;
import com.azure.resourcemanager.eventhubs.fluent.models.EHNamespaceInner;
import com.azure.resourcemanager.eventhubs.models.EventHub;
import com.azure.resourcemanager.eventhubs.models.EventHubNamespaceAuthorizationRule;
import com.azure.resourcemanager.eventhubs.models.EventHubNamespaceSkuType;
import com.azure.resourcemanager.eventhubs.models.TlsVersion;
import com.azure.resourcemanager.resources.fluentcore.arm.models.GroupableResource;
import com.azure.resourcemanager.resources.fluentcore.arm.models.Resource;
import com.azure.resourcemanager.resources.fluentcore.model.Appliable;
import com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.azure.resourcemanager.resources.fluentcore.model.Refreshable;
import com.azure.resourcemanager.resources.fluentcore.model.Updatable;
import java.time.OffsetDateTime;

public interface EventHubNamespace
extends GroupableResource<EventHubsManager, EHNamespaceInner>,
Refreshable<EventHubNamespace>,
Updatable<Update> {
    public EventHubNamespaceSkuType sku();

    public String azureInsightMetricId();

    public String serviceBusEndpoint();

    public OffsetDateTime createdAt();

    public OffsetDateTime updatedAt();

    public String provisioningState();

    public boolean isAutoScaleEnabled();

    public int currentThroughputUnits();

    public int throughputUnitsUpperLimit();

    public PagedFlux<EventHub> listEventHubsAsync();

    public PagedFlux<EventHubNamespaceAuthorizationRule> listAuthorizationRulesAsync();

    public PagedIterable<EventHub> listEventHubs();

    public PagedIterable<EventHubNamespaceAuthorizationRule> listAuthorizationRules();

    public TlsVersion minimumTlsVersion();

    public boolean zoneRedundant();

    public static interface UpdateStages {

        public static interface WithMinimumTlsVersion {
            public Update withMinimumTlsVersion(TlsVersion var1);
        }

        public static interface WithThroughputConfiguration {
            public Update withAutoScaling();

            public Update withCurrentThroughputUnits(int var1);

            public Update withThroughputUnitsUpperLimit(int var1);
        }

        public static interface WithAuthorizationRule {
            public Update withNewSendRule(String var1);

            public Update withNewListenRule(String var1);

            public Update withNewManageRule(String var1);

            public Update withoutAuthorizationRule(String var1);
        }

        public static interface WithEventHub {
            public Update withNewEventHub(String var1);

            public Update withNewEventHub(String var1, int var2);

            public Update withNewEventHub(String var1, int var2, int var3);

            public Update withoutEventHub(String var1);
        }

        public static interface WithSku {
            public Update withSku(EventHubNamespaceSkuType var1);
        }
    }

    public static interface Update
    extends Appliable<EventHubNamespace>,
    Resource.UpdateWithTags<Update>,
    UpdateStages.WithSku,
    UpdateStages.WithEventHub,
    UpdateStages.WithAuthorizationRule,
    UpdateStages.WithThroughputConfiguration,
    UpdateStages.WithMinimumTlsVersion {
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<EventHubNamespace>,
        Resource.DefinitionWithTags<WithCreate>,
        WithSku,
        WithEventHub,
        WithAuthorizationRule,
        WithThroughputConfiguration,
        WithMinimumTlsVersion,
        WithZoneRedundant {
        }

        public static interface WithZoneRedundant {
            public WithCreate enableZoneRedundant();
        }

        public static interface WithMinimumTlsVersion {
            public WithCreate withMinimumTlsVersion(TlsVersion var1);
        }

        public static interface WithThroughputConfiguration {
            public WithCreate withAutoScaling();

            public WithCreate withCurrentThroughputUnits(int var1);

            public WithCreate withThroughputUnitsUpperLimit(int var1);
        }

        public static interface WithAuthorizationRule {
            public WithCreate withNewSendRule(String var1);

            public WithCreate withNewListenRule(String var1);

            public WithCreate withNewManageRule(String var1);
        }

        public static interface WithEventHub {
            public WithCreate withNewEventHub(String var1);

            public WithCreate withNewEventHub(String var1, int var2);

            public WithCreate withNewEventHub(String var1, int var2, int var3);
        }

        public static interface WithSku {
            public WithCreate withSku(EventHubNamespaceSkuType var1);
        }

        public static interface WithGroup
        extends GroupableResource.DefinitionStages.WithGroup<WithCreate> {
        }

        public static interface Blank
        extends Resource.DefinitionWithRegion<WithGroup> {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithGroup,
    DefinitionStages.WithCreate {
    }
}

