// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventhubs.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Properties to configure retention settings for the eventhub.
 */
@Fluent
public final class RetentionDescription implements JsonSerializable<RetentionDescription> {
    /*
     * Enumerates the possible values for cleanup policy
     */
    private CleanupPolicyRetentionDescription cleanupPolicy;

    /*
     * Number of hours to retain the events for this Event Hub. This value is only used when cleanupPolicy is Delete. If
     * cleanupPolicy is Compact the returned value of this property is Long.MaxValue
     */
    private Long retentionTimeInHours;

    /*
     * Number of hours to retain the tombstone markers of a compacted Event Hub. This value is only used when
     * cleanupPolicy is Compact. Consumer must complete reading the tombstone marker within this specified amount of
     * time if consumer begins from starting offset to ensure they get a valid snapshot for the specific key described
     * by the tombstone marker within the compacted Event Hub
     */
    private Integer tombstoneRetentionTimeInHours;

    /**
     * Creates an instance of RetentionDescription class.
     */
    public RetentionDescription() {
    }

    /**
     * Get the cleanupPolicy property: Enumerates the possible values for cleanup policy.
     * 
     * @return the cleanupPolicy value.
     */
    public CleanupPolicyRetentionDescription cleanupPolicy() {
        return this.cleanupPolicy;
    }

    /**
     * Set the cleanupPolicy property: Enumerates the possible values for cleanup policy.
     * 
     * @param cleanupPolicy the cleanupPolicy value to set.
     * @return the RetentionDescription object itself.
     */
    public RetentionDescription withCleanupPolicy(CleanupPolicyRetentionDescription cleanupPolicy) {
        this.cleanupPolicy = cleanupPolicy;
        return this;
    }

    /**
     * Get the retentionTimeInHours property: Number of hours to retain the events for this Event Hub. This value is
     * only used when cleanupPolicy is Delete. If cleanupPolicy is Compact the returned value of this property is
     * Long.MaxValue.
     * 
     * @return the retentionTimeInHours value.
     */
    public Long retentionTimeInHours() {
        return this.retentionTimeInHours;
    }

    /**
     * Set the retentionTimeInHours property: Number of hours to retain the events for this Event Hub. This value is
     * only used when cleanupPolicy is Delete. If cleanupPolicy is Compact the returned value of this property is
     * Long.MaxValue.
     * 
     * @param retentionTimeInHours the retentionTimeInHours value to set.
     * @return the RetentionDescription object itself.
     */
    public RetentionDescription withRetentionTimeInHours(Long retentionTimeInHours) {
        this.retentionTimeInHours = retentionTimeInHours;
        return this;
    }

    /**
     * Get the tombstoneRetentionTimeInHours property: Number of hours to retain the tombstone markers of a compacted
     * Event Hub. This value is only used when cleanupPolicy is Compact. Consumer must complete reading the tombstone
     * marker within this specified amount of time if consumer begins from starting offset to ensure they get a valid
     * snapshot for the specific key described by the tombstone marker within the compacted Event Hub.
     * 
     * @return the tombstoneRetentionTimeInHours value.
     */
    public Integer tombstoneRetentionTimeInHours() {
        return this.tombstoneRetentionTimeInHours;
    }

    /**
     * Set the tombstoneRetentionTimeInHours property: Number of hours to retain the tombstone markers of a compacted
     * Event Hub. This value is only used when cleanupPolicy is Compact. Consumer must complete reading the tombstone
     * marker within this specified amount of time if consumer begins from starting offset to ensure they get a valid
     * snapshot for the specific key described by the tombstone marker within the compacted Event Hub.
     * 
     * @param tombstoneRetentionTimeInHours the tombstoneRetentionTimeInHours value to set.
     * @return the RetentionDescription object itself.
     */
    public RetentionDescription withTombstoneRetentionTimeInHours(Integer tombstoneRetentionTimeInHours) {
        this.tombstoneRetentionTimeInHours = tombstoneRetentionTimeInHours;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("cleanupPolicy", this.cleanupPolicy == null ? null : this.cleanupPolicy.toString());
        jsonWriter.writeNumberField("retentionTimeInHours", this.retentionTimeInHours);
        jsonWriter.writeNumberField("tombstoneRetentionTimeInHours", this.tombstoneRetentionTimeInHours);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RetentionDescription from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RetentionDescription if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RetentionDescription.
     */
    public static RetentionDescription fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RetentionDescription deserializedRetentionDescription = new RetentionDescription();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("cleanupPolicy".equals(fieldName)) {
                    deserializedRetentionDescription.cleanupPolicy
                        = CleanupPolicyRetentionDescription.fromString(reader.getString());
                } else if ("retentionTimeInHours".equals(fieldName)) {
                    deserializedRetentionDescription.retentionTimeInHours = reader.getNullable(JsonReader::getLong);
                } else if ("tombstoneRetentionTimeInHours".equals(fieldName)) {
                    deserializedRetentionDescription.tombstoneRetentionTimeInHours
                        = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRetentionDescription;
        });
    }
}
