/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventhubs.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventhubs.models.DefaultAction;
import com.azure.resourcemanager.eventhubs.models.NWRuleSetIpRules;
import com.azure.resourcemanager.eventhubs.models.NWRuleSetVirtualNetworkRules;
import com.azure.resourcemanager.eventhubs.models.PublicNetworkAccessFlag;
import java.io.IOException;
import java.util.List;

public final class NetworkRuleSetProperties
implements JsonSerializable<NetworkRuleSetProperties> {
    private Boolean trustedServiceAccessEnabled;
    private DefaultAction defaultAction;
    private List<NWRuleSetVirtualNetworkRules> virtualNetworkRules;
    private List<NWRuleSetIpRules> ipRules;
    private PublicNetworkAccessFlag publicNetworkAccess;

    public Boolean trustedServiceAccessEnabled() {
        return this.trustedServiceAccessEnabled;
    }

    public NetworkRuleSetProperties withTrustedServiceAccessEnabled(Boolean trustedServiceAccessEnabled) {
        this.trustedServiceAccessEnabled = trustedServiceAccessEnabled;
        return this;
    }

    public DefaultAction defaultAction() {
        return this.defaultAction;
    }

    public NetworkRuleSetProperties withDefaultAction(DefaultAction defaultAction) {
        this.defaultAction = defaultAction;
        return this;
    }

    public List<NWRuleSetVirtualNetworkRules> virtualNetworkRules() {
        return this.virtualNetworkRules;
    }

    public NetworkRuleSetProperties withVirtualNetworkRules(List<NWRuleSetVirtualNetworkRules> virtualNetworkRules) {
        this.virtualNetworkRules = virtualNetworkRules;
        return this;
    }

    public List<NWRuleSetIpRules> ipRules() {
        return this.ipRules;
    }

    public NetworkRuleSetProperties withIpRules(List<NWRuleSetIpRules> ipRules) {
        this.ipRules = ipRules;
        return this;
    }

    public PublicNetworkAccessFlag publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public NetworkRuleSetProperties withPublicNetworkAccess(PublicNetworkAccessFlag publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public void validate() {
        if (this.virtualNetworkRules() != null) {
            this.virtualNetworkRules().forEach(e -> e.validate());
        }
        if (this.ipRules() != null) {
            this.ipRules().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("trustedServiceAccessEnabled", this.trustedServiceAccessEnabled);
        jsonWriter.writeStringField("defaultAction", this.defaultAction == null ? null : this.defaultAction.toString());
        jsonWriter.writeArrayField("virtualNetworkRules", this.virtualNetworkRules, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("ipRules", this.ipRules, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("publicNetworkAccess", this.publicNetworkAccess == null ? null : this.publicNetworkAccess.toString());
        return jsonWriter.writeEndObject();
    }

    public static NetworkRuleSetProperties fromJson(JsonReader jsonReader) throws IOException {
        return (NetworkRuleSetProperties)jsonReader.readObject(reader -> {
            NetworkRuleSetProperties deserializedNetworkRuleSetProperties = new NetworkRuleSetProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("trustedServiceAccessEnabled".equals(fieldName)) {
                    deserializedNetworkRuleSetProperties.trustedServiceAccessEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("defaultAction".equals(fieldName)) {
                    deserializedNetworkRuleSetProperties.defaultAction = DefaultAction.fromString(reader.getString());
                    continue;
                }
                if ("virtualNetworkRules".equals(fieldName)) {
                    List virtualNetworkRules;
                    deserializedNetworkRuleSetProperties.virtualNetworkRules = virtualNetworkRules = reader.readArray(reader1 -> NWRuleSetVirtualNetworkRules.fromJson(reader1));
                    continue;
                }
                if ("ipRules".equals(fieldName)) {
                    List ipRules;
                    deserializedNetworkRuleSetProperties.ipRules = ipRules = reader.readArray(reader1 -> NWRuleSetIpRules.fromJson(reader1));
                    continue;
                }
                if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedNetworkRuleSetProperties.publicNetworkAccess = PublicNetworkAccessFlag.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetworkRuleSetProperties;
        });
    }
}

