/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventhubs.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventhubs.models.ApplicationGroupPolicy;
import java.io.IOException;
import java.util.List;

public final class ApplicationGroupProperties
implements JsonSerializable<ApplicationGroupProperties> {
    private Boolean isEnabled;
    private String clientAppGroupIdentifier;
    private List<ApplicationGroupPolicy> policies;
    private static final ClientLogger LOGGER = new ClientLogger(ApplicationGroupProperties.class);

    public Boolean isEnabled() {
        return this.isEnabled;
    }

    public ApplicationGroupProperties withIsEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    public String clientAppGroupIdentifier() {
        return this.clientAppGroupIdentifier;
    }

    public ApplicationGroupProperties withClientAppGroupIdentifier(String clientAppGroupIdentifier) {
        this.clientAppGroupIdentifier = clientAppGroupIdentifier;
        return this;
    }

    public List<ApplicationGroupPolicy> policies() {
        return this.policies;
    }

    public ApplicationGroupProperties withPolicies(List<ApplicationGroupPolicy> policies) {
        this.policies = policies;
        return this;
    }

    public void validate() {
        if (this.clientAppGroupIdentifier() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property clientAppGroupIdentifier in model ApplicationGroupProperties"));
        }
        if (this.policies() != null) {
            this.policies().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("clientAppGroupIdentifier", this.clientAppGroupIdentifier);
        jsonWriter.writeBooleanField("isEnabled", this.isEnabled);
        jsonWriter.writeArrayField("policies", this.policies, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ApplicationGroupProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ApplicationGroupProperties)jsonReader.readObject(reader -> {
            ApplicationGroupProperties deserializedApplicationGroupProperties = new ApplicationGroupProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("clientAppGroupIdentifier".equals(fieldName)) {
                    deserializedApplicationGroupProperties.clientAppGroupIdentifier = reader.getString();
                    continue;
                }
                if ("isEnabled".equals(fieldName)) {
                    deserializedApplicationGroupProperties.isEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("policies".equals(fieldName)) {
                    List policies;
                    deserializedApplicationGroupProperties.policies = policies = reader.readArray(reader1 -> ApplicationGroupPolicy.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApplicationGroupProperties;
        });
    }
}

