/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventhubs.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventhubs.models.AccessRights;
import java.io.IOException;
import java.util.List;

public final class AuthorizationRuleProperties
implements JsonSerializable<AuthorizationRuleProperties> {
    private List<AccessRights> rights;
    private static final ClientLogger LOGGER = new ClientLogger(AuthorizationRuleProperties.class);

    public List<AccessRights> rights() {
        return this.rights;
    }

    public AuthorizationRuleProperties withRights(List<AccessRights> rights) {
        this.rights = rights;
        return this;
    }

    public void validate() {
        if (this.rights() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property rights in model AuthorizationRuleProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("rights", this.rights, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        return jsonWriter.writeEndObject();
    }

    public static AuthorizationRuleProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AuthorizationRuleProperties)jsonReader.readObject(reader -> {
            AuthorizationRuleProperties deserializedAuthorizationRuleProperties = new AuthorizationRuleProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("rights".equals(fieldName)) {
                    List rights;
                    deserializedAuthorizationRuleProperties.rights = rights = reader.readArray(reader1 -> AccessRights.fromString(reader1.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAuthorizationRuleProperties;
        });
    }
}

