// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventhubs.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventhubs.fluent.models.SchemaGroupInner;
import java.io.IOException;
import java.util.List;

/**
 * The result of the List SchemaGroup operation.
 */
@Fluent
public final class SchemaGroupListResult implements JsonSerializable<SchemaGroupListResult> {
    /*
     * Result of the List SchemaGroups operation.
     */
    private List<SchemaGroupInner> value;

    /*
     * Link to the next set of results. Not empty if Value contains incomplete list of Schema Groups.
     */
    private String nextLink;

    /**
     * Creates an instance of SchemaGroupListResult class.
     */
    public SchemaGroupListResult() {
    }

    /**
     * Get the value property: Result of the List SchemaGroups operation.
     * 
     * @return the value value.
     */
    public List<SchemaGroupInner> value() {
        return this.value;
    }

    /**
     * Set the value property: Result of the List SchemaGroups operation.
     * 
     * @param value the value value to set.
     * @return the SchemaGroupListResult object itself.
     */
    public SchemaGroupListResult withValue(List<SchemaGroupInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: Link to the next set of results. Not empty if Value contains incomplete list of Schema
     * Groups.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: Link to the next set of results. Not empty if Value contains incomplete list of Schema
     * Groups.
     * 
     * @param nextLink the nextLink value to set.
     * @return the SchemaGroupListResult object itself.
     */
    public SchemaGroupListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SchemaGroupListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SchemaGroupListResult if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SchemaGroupListResult.
     */
    public static SchemaGroupListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SchemaGroupListResult deserializedSchemaGroupListResult = new SchemaGroupListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<SchemaGroupInner> value = reader.readArray(reader1 -> SchemaGroupInner.fromJson(reader1));
                    deserializedSchemaGroupListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedSchemaGroupListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSchemaGroupListResult;
        });
    }
}
