// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventhubs.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventhubs.fluent.models.EHNamespaceInner;
import java.io.IOException;
import java.util.List;

/**
 * The response of the List Namespace operation.
 */
@Fluent
public final class EHNamespaceListResult implements JsonSerializable<EHNamespaceListResult> {
    /*
     * Result of the List Namespace operation
     */
    private List<EHNamespaceInner> value;

    /*
     * Link to the next set of results. Not empty if Value contains incomplete list of namespaces.
     */
    private String nextLink;

    /**
     * Creates an instance of EHNamespaceListResult class.
     */
    public EHNamespaceListResult() {
    }

    /**
     * Get the value property: Result of the List Namespace operation.
     * 
     * @return the value value.
     */
    public List<EHNamespaceInner> value() {
        return this.value;
    }

    /**
     * Set the value property: Result of the List Namespace operation.
     * 
     * @param value the value value to set.
     * @return the EHNamespaceListResult object itself.
     */
    public EHNamespaceListResult withValue(List<EHNamespaceInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: Link to the next set of results. Not empty if Value contains incomplete list of
     * namespaces.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: Link to the next set of results. Not empty if Value contains incomplete list of
     * namespaces.
     * 
     * @param nextLink the nextLink value to set.
     * @return the EHNamespaceListResult object itself.
     */
    public EHNamespaceListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of EHNamespaceListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of EHNamespaceListResult if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the EHNamespaceListResult.
     */
    public static EHNamespaceListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            EHNamespaceListResult deserializedEHNamespaceListResult = new EHNamespaceListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<EHNamespaceInner> value = reader.readArray(reader1 -> EHNamespaceInner.fromJson(reader1));
                    deserializedEHNamespaceListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedEHNamespaceListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedEHNamespaceListResult;
        });
    }
}
