// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventhubs.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventhubs.fluent.models.NetworkSecurityPerimeterConfigurationProperties;
import java.io.IOException;
import java.util.List;

/**
 * Network Security Perimeter related configurations of a given namespace.
 */
@Immutable
public final class NetworkSecurityPerimeterConfiguration extends ProxyResource {
    /*
     * Properties of the Network Security Perimeter Configuration
     */
    private NetworkSecurityPerimeterConfigurationProperties innerProperties;

    /*
     * The geo-location where the resource lives
     */
    private String location;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * The type of the resource.
     */
    private String type;

    /**
     * Creates an instance of NetworkSecurityPerimeterConfiguration class.
     */
    public NetworkSecurityPerimeterConfiguration() {
    }

    /**
     * Get the innerProperties property: Properties of the Network Security Perimeter Configuration.
     * 
     * @return the innerProperties value.
     */
    private NetworkSecurityPerimeterConfigurationProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the location property: The geo-location where the resource lives.
     * 
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the provisioningState property: Provisioning state of NetworkSecurityPerimeter configuration propagation.
     * 
     * @return the provisioningState value.
     */
    public NetworkSecurityPerimeterConfigurationProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Set the provisioningState property: Provisioning state of NetworkSecurityPerimeter configuration propagation.
     * 
     * @param provisioningState the provisioningState value to set.
     * @return the NetworkSecurityPerimeterConfiguration object itself.
     */
    public NetworkSecurityPerimeterConfiguration
        withProvisioningState(NetworkSecurityPerimeterConfigurationProvisioningState provisioningState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkSecurityPerimeterConfigurationProperties();
        }
        this.innerProperties().withProvisioningState(provisioningState);
        return this;
    }

    /**
     * Get the provisioningIssues property: List of Provisioning Issues if any.
     * 
     * @return the provisioningIssues value.
     */
    public List<ProvisioningIssue> provisioningIssues() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningIssues();
    }

    /**
     * Set the provisioningIssues property: List of Provisioning Issues if any.
     * 
     * @param provisioningIssues the provisioningIssues value to set.
     * @return the NetworkSecurityPerimeterConfiguration object itself.
     */
    public NetworkSecurityPerimeterConfiguration withProvisioningIssues(List<ProvisioningIssue> provisioningIssues) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkSecurityPerimeterConfigurationProperties();
        }
        this.innerProperties().withProvisioningIssues(provisioningIssues);
        return this;
    }

    /**
     * Get the networkSecurityPerimeter property: NetworkSecurityPerimeter related information.
     * 
     * @return the networkSecurityPerimeter value.
     */
    public NetworkSecurityPerimeter networkSecurityPerimeter() {
        return this.innerProperties() == null ? null : this.innerProperties().networkSecurityPerimeter();
    }

    /**
     * Get the resourceAssociation property: Information about resource association.
     * 
     * @return the resourceAssociation value.
     */
    public NetworkSecurityPerimeterConfigurationPropertiesResourceAssociation resourceAssociation() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceAssociation();
    }

    /**
     * Get the profile property: Information about current network profile.
     * 
     * @return the profile value.
     */
    public NetworkSecurityPerimeterConfigurationPropertiesProfile profile() {
        return this.innerProperties() == null ? null : this.innerProperties().profile();
    }

    /**
     * Get the isBackingResource property: True if the EventHub namespace is backed by another Azure resource and not
     * visible to end users.
     * 
     * @return the isBackingResource value.
     */
    public Boolean isBackingResource() {
        return this.innerProperties() == null ? null : this.innerProperties().isBackingResource();
    }

    /**
     * Get the applicableFeatures property: Indicates that the NSP controls related to backing association are only
     * applicable to a specific feature in backing resource's data plane.
     * 
     * @return the applicableFeatures value.
     */
    public List<String> applicableFeatures() {
        return this.innerProperties() == null ? null : this.innerProperties().applicableFeatures();
    }

    /**
     * Get the parentAssociationName property: Source Resource Association name.
     * 
     * @return the parentAssociationName value.
     */
    public String parentAssociationName() {
        return this.innerProperties() == null ? null : this.innerProperties().parentAssociationName();
    }

    /**
     * Get the sourceResourceId property: ARM Id of source resource.
     * 
     * @return the sourceResourceId value.
     */
    public String sourceResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().sourceResourceId();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NetworkSecurityPerimeterConfiguration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NetworkSecurityPerimeterConfiguration if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the NetworkSecurityPerimeterConfiguration.
     */
    public static NetworkSecurityPerimeterConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NetworkSecurityPerimeterConfiguration deserializedNetworkSecurityPerimeterConfiguration
                = new NetworkSecurityPerimeterConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterConfiguration.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterConfiguration.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterConfiguration.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterConfiguration.innerProperties
                        = NetworkSecurityPerimeterConfigurationProperties.fromJson(reader);
                } else if ("location".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterConfiguration.location = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNetworkSecurityPerimeterConfiguration;
        });
    }
}
