// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventhubs.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventhubs.models.NetworkSecurityPerimeter;
import com.azure.resourcemanager.eventhubs.models.NetworkSecurityPerimeterConfigurationPropertiesProfile;
import com.azure.resourcemanager.eventhubs.models.NetworkSecurityPerimeterConfigurationPropertiesResourceAssociation;
import com.azure.resourcemanager.eventhubs.models.NetworkSecurityPerimeterConfigurationProvisioningState;
import com.azure.resourcemanager.eventhubs.models.ProvisioningIssue;
import java.io.IOException;
import java.util.List;

/**
 * Properties of NetworkSecurityPerimeterConfiguration.
 */
@Fluent
public final class NetworkSecurityPerimeterConfigurationProperties
    implements JsonSerializable<NetworkSecurityPerimeterConfigurationProperties> {
    /*
     * Provisioning state of NetworkSecurityPerimeter configuration propagation
     */
    private NetworkSecurityPerimeterConfigurationProvisioningState provisioningState;

    /*
     * List of Provisioning Issues if any
     */
    private List<ProvisioningIssue> provisioningIssues;

    /*
     * NetworkSecurityPerimeter related information
     */
    private NetworkSecurityPerimeter networkSecurityPerimeter;

    /*
     * Information about resource association
     */
    private NetworkSecurityPerimeterConfigurationPropertiesResourceAssociation resourceAssociation;

    /*
     * Information about current network profile
     */
    private NetworkSecurityPerimeterConfigurationPropertiesProfile profile;

    /*
     * True if the EventHub namespace is backed by another Azure resource and not visible to end users.
     */
    private Boolean isBackingResource;

    /*
     * Indicates that the NSP controls related to backing association are only applicable to a specific feature in
     * backing resource's data plane.
     */
    private List<String> applicableFeatures;

    /*
     * Source Resource Association name
     */
    private String parentAssociationName;

    /*
     * ARM Id of source resource
     */
    private String sourceResourceId;

    /**
     * Creates an instance of NetworkSecurityPerimeterConfigurationProperties class.
     */
    public NetworkSecurityPerimeterConfigurationProperties() {
    }

    /**
     * Get the provisioningState property: Provisioning state of NetworkSecurityPerimeter configuration propagation.
     * 
     * @return the provisioningState value.
     */
    public NetworkSecurityPerimeterConfigurationProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Set the provisioningState property: Provisioning state of NetworkSecurityPerimeter configuration propagation.
     * 
     * @param provisioningState the provisioningState value to set.
     * @return the NetworkSecurityPerimeterConfigurationProperties object itself.
     */
    public NetworkSecurityPerimeterConfigurationProperties
        withProvisioningState(NetworkSecurityPerimeterConfigurationProvisioningState provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    /**
     * Get the provisioningIssues property: List of Provisioning Issues if any.
     * 
     * @return the provisioningIssues value.
     */
    public List<ProvisioningIssue> provisioningIssues() {
        return this.provisioningIssues;
    }

    /**
     * Set the provisioningIssues property: List of Provisioning Issues if any.
     * 
     * @param provisioningIssues the provisioningIssues value to set.
     * @return the NetworkSecurityPerimeterConfigurationProperties object itself.
     */
    public NetworkSecurityPerimeterConfigurationProperties
        withProvisioningIssues(List<ProvisioningIssue> provisioningIssues) {
        this.provisioningIssues = provisioningIssues;
        return this;
    }

    /**
     * Get the networkSecurityPerimeter property: NetworkSecurityPerimeter related information.
     * 
     * @return the networkSecurityPerimeter value.
     */
    public NetworkSecurityPerimeter networkSecurityPerimeter() {
        return this.networkSecurityPerimeter;
    }

    /**
     * Get the resourceAssociation property: Information about resource association.
     * 
     * @return the resourceAssociation value.
     */
    public NetworkSecurityPerimeterConfigurationPropertiesResourceAssociation resourceAssociation() {
        return this.resourceAssociation;
    }

    /**
     * Get the profile property: Information about current network profile.
     * 
     * @return the profile value.
     */
    public NetworkSecurityPerimeterConfigurationPropertiesProfile profile() {
        return this.profile;
    }

    /**
     * Get the isBackingResource property: True if the EventHub namespace is backed by another Azure resource and not
     * visible to end users.
     * 
     * @return the isBackingResource value.
     */
    public Boolean isBackingResource() {
        return this.isBackingResource;
    }

    /**
     * Get the applicableFeatures property: Indicates that the NSP controls related to backing association are only
     * applicable to a specific feature in backing resource's data plane.
     * 
     * @return the applicableFeatures value.
     */
    public List<String> applicableFeatures() {
        return this.applicableFeatures;
    }

    /**
     * Get the parentAssociationName property: Source Resource Association name.
     * 
     * @return the parentAssociationName value.
     */
    public String parentAssociationName() {
        return this.parentAssociationName;
    }

    /**
     * Get the sourceResourceId property: ARM Id of source resource.
     * 
     * @return the sourceResourceId value.
     */
    public String sourceResourceId() {
        return this.sourceResourceId;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (provisioningIssues() != null) {
            provisioningIssues().forEach(e -> e.validate());
        }
        if (networkSecurityPerimeter() != null) {
            networkSecurityPerimeter().validate();
        }
        if (resourceAssociation() != null) {
            resourceAssociation().validate();
        }
        if (profile() != null) {
            profile().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("provisioningState",
            this.provisioningState == null ? null : this.provisioningState.toString());
        jsonWriter.writeArrayField("provisioningIssues", this.provisioningIssues,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NetworkSecurityPerimeterConfigurationProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NetworkSecurityPerimeterConfigurationProperties if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the NetworkSecurityPerimeterConfigurationProperties.
     */
    public static NetworkSecurityPerimeterConfigurationProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NetworkSecurityPerimeterConfigurationProperties deserializedNetworkSecurityPerimeterConfigurationProperties
                = new NetworkSecurityPerimeterConfigurationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("provisioningState".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterConfigurationProperties.provisioningState
                        = NetworkSecurityPerimeterConfigurationProvisioningState.fromString(reader.getString());
                } else if ("provisioningIssues".equals(fieldName)) {
                    List<ProvisioningIssue> provisioningIssues
                        = reader.readArray(reader1 -> ProvisioningIssue.fromJson(reader1));
                    deserializedNetworkSecurityPerimeterConfigurationProperties.provisioningIssues = provisioningIssues;
                } else if ("networkSecurityPerimeter".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterConfigurationProperties.networkSecurityPerimeter
                        = NetworkSecurityPerimeter.fromJson(reader);
                } else if ("resourceAssociation".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterConfigurationProperties.resourceAssociation
                        = NetworkSecurityPerimeterConfigurationPropertiesResourceAssociation.fromJson(reader);
                } else if ("profile".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterConfigurationProperties.profile
                        = NetworkSecurityPerimeterConfigurationPropertiesProfile.fromJson(reader);
                } else if ("isBackingResource".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterConfigurationProperties.isBackingResource
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("applicableFeatures".equals(fieldName)) {
                    List<String> applicableFeatures = reader.readArray(reader1 -> reader1.getString());
                    deserializedNetworkSecurityPerimeterConfigurationProperties.applicableFeatures = applicableFeatures;
                } else if ("parentAssociationName".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterConfigurationProperties.parentAssociationName
                        = reader.getString();
                } else if ("sourceResourceId".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterConfigurationProperties.sourceResourceId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNetworkSecurityPerimeterConfigurationProperties;
        });
    }
}
