/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventhubs.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventhubs.models.ClusterSkuName;
import java.io.IOException;

public final class ClusterSku
implements JsonSerializable<ClusterSku> {
    private ClusterSkuName name;
    private Integer capacity;
    private static final ClientLogger LOGGER = new ClientLogger(ClusterSku.class);

    public ClusterSkuName name() {
        return this.name;
    }

    public ClusterSku withName(ClusterSkuName name) {
        this.name = name;
        return this;
    }

    public Integer capacity() {
        return this.capacity;
    }

    public ClusterSku withCapacity(Integer capacity) {
        this.capacity = capacity;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model ClusterSku"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name == null ? null : this.name.toString());
        jsonWriter.writeNumberField("capacity", (Number)this.capacity);
        return jsonWriter.writeEndObject();
    }

    public static ClusterSku fromJson(JsonReader jsonReader) throws IOException {
        return (ClusterSku)jsonReader.readObject(reader -> {
            ClusterSku deserializedClusterSku = new ClusterSku();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedClusterSku.name = ClusterSkuName.fromString(reader.getString());
                    continue;
                }
                if ("capacity".equals(fieldName)) {
                    deserializedClusterSku.capacity = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedClusterSku;
        });
    }
}

