// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventhubs.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventhubs.models.PrivateLinkResource;
import java.io.IOException;
import java.util.List;

/**
 * Result of the List private link resources operation.
 */
@Fluent
public final class PrivateLinkResourcesListResultInner
    implements JsonSerializable<PrivateLinkResourcesListResultInner> {
    /*
     * A collection of private link resources
     */
    private List<PrivateLinkResource> value;

    /*
     * A link for the next page of private link resources.
     */
    private String nextLink;

    /**
     * Creates an instance of PrivateLinkResourcesListResultInner class.
     */
    public PrivateLinkResourcesListResultInner() {
    }

    /**
     * Get the value property: A collection of private link resources.
     * 
     * @return the value value.
     */
    public List<PrivateLinkResource> value() {
        return this.value;
    }

    /**
     * Set the value property: A collection of private link resources.
     * 
     * @param value the value value to set.
     * @return the PrivateLinkResourcesListResultInner object itself.
     */
    public PrivateLinkResourcesListResultInner withValue(List<PrivateLinkResource> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: A link for the next page of private link resources.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: A link for the next page of private link resources.
     * 
     * @param nextLink the nextLink value to set.
     * @return the PrivateLinkResourcesListResultInner object itself.
     */
    public PrivateLinkResourcesListResultInner withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PrivateLinkResourcesListResultInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PrivateLinkResourcesListResultInner if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the PrivateLinkResourcesListResultInner.
     */
    public static PrivateLinkResourcesListResultInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PrivateLinkResourcesListResultInner deserializedPrivateLinkResourcesListResultInner
                = new PrivateLinkResourcesListResultInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<PrivateLinkResource> value
                        = reader.readArray(reader1 -> PrivateLinkResource.fromJson(reader1));
                    deserializedPrivateLinkResourcesListResultInner.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedPrivateLinkResourcesListResultInner.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPrivateLinkResourcesListResultInner;
        });
    }
}
