/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventhubs.models;

import com.azure.resourcemanager.eventhubs.fluent.models.DestinationProperties;
import com.azure.resourcemanager.eventhubs.models.CaptureIdentity;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.UUID;

public final class Destination {
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="identity")
    private CaptureIdentity identity;
    @JsonProperty(value="properties")
    private DestinationProperties innerProperties;

    public String name() {
        return this.name;
    }

    public Destination withName(String name) {
        this.name = name;
        return this;
    }

    public CaptureIdentity identity() {
        return this.identity;
    }

    public Destination withIdentity(CaptureIdentity identity) {
        this.identity = identity;
        return this;
    }

    private DestinationProperties innerProperties() {
        return this.innerProperties;
    }

    public String storageAccountResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().storageAccountResourceId();
    }

    public Destination withStorageAccountResourceId(String storageAccountResourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DestinationProperties();
        }
        this.innerProperties().withStorageAccountResourceId(storageAccountResourceId);
        return this;
    }

    public String blobContainer() {
        return this.innerProperties() == null ? null : this.innerProperties().blobContainer();
    }

    public Destination withBlobContainer(String blobContainer) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DestinationProperties();
        }
        this.innerProperties().withBlobContainer(blobContainer);
        return this;
    }

    public String archiveNameFormat() {
        return this.innerProperties() == null ? null : this.innerProperties().archiveNameFormat();
    }

    public Destination withArchiveNameFormat(String archiveNameFormat) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DestinationProperties();
        }
        this.innerProperties().withArchiveNameFormat(archiveNameFormat);
        return this;
    }

    public UUID dataLakeSubscriptionId() {
        return this.innerProperties() == null ? null : this.innerProperties().dataLakeSubscriptionId();
    }

    public Destination withDataLakeSubscriptionId(UUID dataLakeSubscriptionId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DestinationProperties();
        }
        this.innerProperties().withDataLakeSubscriptionId(dataLakeSubscriptionId);
        return this;
    }

    public String dataLakeAccountName() {
        return this.innerProperties() == null ? null : this.innerProperties().dataLakeAccountName();
    }

    public Destination withDataLakeAccountName(String dataLakeAccountName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DestinationProperties();
        }
        this.innerProperties().withDataLakeAccountName(dataLakeAccountName);
        return this;
    }

    public String dataLakeFolderPath() {
        return this.innerProperties() == null ? null : this.innerProperties().dataLakeFolderPath();
    }

    public Destination withDataLakeFolderPath(String dataLakeFolderPath) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DestinationProperties();
        }
        this.innerProperties().withDataLakeFolderPath(dataLakeFolderPath);
        return this;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

