// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventhubs.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Event Hubs Cluster properties supplied in responses in List or Get operations. */
@Immutable
public final class ClusterProperties {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(ClusterProperties.class);

    /*
     * The UTC time when the Event Hubs Cluster was created.
     */
    @JsonProperty(value = "createdAt", access = JsonProperty.Access.WRITE_ONLY)
    private String createdAt;

    /*
     * The UTC time when the Event Hubs Cluster was last updated.
     */
    @JsonProperty(value = "updatedAt", access = JsonProperty.Access.WRITE_ONLY)
    private String updatedAt;

    /*
     * The metric ID of the cluster resource. Provided by the service and not
     * modifiable by the user.
     */
    @JsonProperty(value = "metricId", access = JsonProperty.Access.WRITE_ONLY)
    private String metricId;

    /*
     * Status of the Cluster resource
     */
    @JsonProperty(value = "status", access = JsonProperty.Access.WRITE_ONLY)
    private String status;

    /**
     * Get the createdAt property: The UTC time when the Event Hubs Cluster was created.
     *
     * @return the createdAt value.
     */
    public String createdAt() {
        return this.createdAt;
    }

    /**
     * Get the updatedAt property: The UTC time when the Event Hubs Cluster was last updated.
     *
     * @return the updatedAt value.
     */
    public String updatedAt() {
        return this.updatedAt;
    }

    /**
     * Get the metricId property: The metric ID of the cluster resource. Provided by the service and not modifiable by
     * the user.
     *
     * @return the metricId value.
     */
    public String metricId() {
        return this.metricId;
    }

    /**
     * Get the status property: Status of the Cluster resource.
     *
     * @return the status value.
     */
    public String status() {
        return this.status;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
