// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventhubs.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.eventhubs.fluent.models.EventhubInner;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The result of the List EventHubs operation. */
@Fluent
public final class EventHubListResult {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(EventHubListResult.class);

    /*
     * Result of the List EventHubs operation.
     */
    @JsonProperty(value = "value")
    private List<EventhubInner> value;

    /*
     * Link to the next set of results. Not empty if Value contains incomplete
     * list of EventHubs.
     */
    @JsonProperty(value = "nextLink")
    private String nextLink;

    /**
     * Get the value property: Result of the List EventHubs operation.
     *
     * @return the value value.
     */
    public List<EventhubInner> value() {
        return this.value;
    }

    /**
     * Set the value property: Result of the List EventHubs operation.
     *
     * @param value the value value to set.
     * @return the EventHubListResult object itself.
     */
    public EventHubListResult withValue(List<EventhubInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: Link to the next set of results. Not empty if Value contains incomplete list of
     * EventHubs.
     *
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: Link to the next set of results. Not empty if Value contains incomplete list of
     * EventHubs.
     *
     * @param nextLink the nextLink value to set.
     * @return the EventHubListResult object itself.
     */
    public EventHubListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
