// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventhubs.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.UUID;

/** Properties describing the storage account, blob container and archive name format for capture destination. */
@Fluent
public final class DestinationProperties {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(DestinationProperties.class);

    /*
     * Resource id of the storage account to be used to create the blobs
     */
    @JsonProperty(value = "storageAccountResourceId")
    private String storageAccountResourceId;

    /*
     * Blob container Name
     */
    @JsonProperty(value = "blobContainer")
    private String blobContainer;

    /*
     * Blob naming convention for archive, e.g.
     * {Namespace}/{EventHub}/{PartitionId}/{Year}/{Month}/{Day}/{Hour}/{Minute}/{Second}.
     * Here all the parameters (Namespace,EventHub .. etc) are mandatory
     * irrespective of order
     */
    @JsonProperty(value = "archiveNameFormat")
    private String archiveNameFormat;

    /*
     * Subscription Id of Azure Data Lake Store
     */
    @JsonProperty(value = "dataLakeSubscriptionId")
    private UUID dataLakeSubscriptionId;

    /*
     * The Azure Data Lake Store name for the captured events
     */
    @JsonProperty(value = "dataLakeAccountName")
    private String dataLakeAccountName;

    /*
     * The destination folder path for the captured events
     */
    @JsonProperty(value = "dataLakeFolderPath")
    private String dataLakeFolderPath;

    /**
     * Get the storageAccountResourceId property: Resource id of the storage account to be used to create the blobs.
     *
     * @return the storageAccountResourceId value.
     */
    public String storageAccountResourceId() {
        return this.storageAccountResourceId;
    }

    /**
     * Set the storageAccountResourceId property: Resource id of the storage account to be used to create the blobs.
     *
     * @param storageAccountResourceId the storageAccountResourceId value to set.
     * @return the DestinationProperties object itself.
     */
    public DestinationProperties withStorageAccountResourceId(String storageAccountResourceId) {
        this.storageAccountResourceId = storageAccountResourceId;
        return this;
    }

    /**
     * Get the blobContainer property: Blob container Name.
     *
     * @return the blobContainer value.
     */
    public String blobContainer() {
        return this.blobContainer;
    }

    /**
     * Set the blobContainer property: Blob container Name.
     *
     * @param blobContainer the blobContainer value to set.
     * @return the DestinationProperties object itself.
     */
    public DestinationProperties withBlobContainer(String blobContainer) {
        this.blobContainer = blobContainer;
        return this;
    }

    /**
     * Get the archiveNameFormat property: Blob naming convention for archive, e.g.
     * {Namespace}/{EventHub}/{PartitionId}/{Year}/{Month}/{Day}/{Hour}/{Minute}/{Second}. Here all the parameters
     * (Namespace,EventHub .. etc) are mandatory irrespective of order.
     *
     * @return the archiveNameFormat value.
     */
    public String archiveNameFormat() {
        return this.archiveNameFormat;
    }

    /**
     * Set the archiveNameFormat property: Blob naming convention for archive, e.g.
     * {Namespace}/{EventHub}/{PartitionId}/{Year}/{Month}/{Day}/{Hour}/{Minute}/{Second}. Here all the parameters
     * (Namespace,EventHub .. etc) are mandatory irrespective of order.
     *
     * @param archiveNameFormat the archiveNameFormat value to set.
     * @return the DestinationProperties object itself.
     */
    public DestinationProperties withArchiveNameFormat(String archiveNameFormat) {
        this.archiveNameFormat = archiveNameFormat;
        return this;
    }

    /**
     * Get the dataLakeSubscriptionId property: Subscription Id of Azure Data Lake Store.
     *
     * @return the dataLakeSubscriptionId value.
     */
    public UUID dataLakeSubscriptionId() {
        return this.dataLakeSubscriptionId;
    }

    /**
     * Set the dataLakeSubscriptionId property: Subscription Id of Azure Data Lake Store.
     *
     * @param dataLakeSubscriptionId the dataLakeSubscriptionId value to set.
     * @return the DestinationProperties object itself.
     */
    public DestinationProperties withDataLakeSubscriptionId(UUID dataLakeSubscriptionId) {
        this.dataLakeSubscriptionId = dataLakeSubscriptionId;
        return this;
    }

    /**
     * Get the dataLakeAccountName property: The Azure Data Lake Store name for the captured events.
     *
     * @return the dataLakeAccountName value.
     */
    public String dataLakeAccountName() {
        return this.dataLakeAccountName;
    }

    /**
     * Set the dataLakeAccountName property: The Azure Data Lake Store name for the captured events.
     *
     * @param dataLakeAccountName the dataLakeAccountName value to set.
     * @return the DestinationProperties object itself.
     */
    public DestinationProperties withDataLakeAccountName(String dataLakeAccountName) {
        this.dataLakeAccountName = dataLakeAccountName;
        return this;
    }

    /**
     * Get the dataLakeFolderPath property: The destination folder path for the captured events.
     *
     * @return the dataLakeFolderPath value.
     */
    public String dataLakeFolderPath() {
        return this.dataLakeFolderPath;
    }

    /**
     * Set the dataLakeFolderPath property: The destination folder path for the captured events.
     *
     * @param dataLakeFolderPath the dataLakeFolderPath value to set.
     * @return the DestinationProperties object itself.
     */
    public DestinationProperties withDataLakeFolderPath(String dataLakeFolderPath) {
        this.dataLakeFolderPath = dataLakeFolderPath;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
