// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.dns.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * An SOA record.
 */
@Fluent
public final class SoaRecord implements JsonSerializable<SoaRecord> {
    /*
     * The domain name of the authoritative name server for this SOA record.
     */
    private String host;

    /*
     * The email contact for this SOA record.
     */
    private String email;

    /*
     * The serial number for this SOA record.
     */
    private Long serialNumber;

    /*
     * The refresh value for this SOA record.
     */
    private Long refreshTime;

    /*
     * The retry time for this SOA record.
     */
    private Long retryTime;

    /*
     * The expire time for this SOA record.
     */
    private Long expireTime;

    /*
     * The minimum value for this SOA record. By convention this is used to determine the negative caching duration.
     */
    private Long minimumTtl;

    /**
     * Creates an instance of SoaRecord class.
     */
    public SoaRecord() {
    }

    /**
     * Get the host property: The domain name of the authoritative name server for this SOA record.
     * 
     * @return the host value.
     */
    public String host() {
        return this.host;
    }

    /**
     * Set the host property: The domain name of the authoritative name server for this SOA record.
     * 
     * @param host the host value to set.
     * @return the SoaRecord object itself.
     */
    public SoaRecord withHost(String host) {
        this.host = host;
        return this;
    }

    /**
     * Get the email property: The email contact for this SOA record.
     * 
     * @return the email value.
     */
    public String email() {
        return this.email;
    }

    /**
     * Set the email property: The email contact for this SOA record.
     * 
     * @param email the email value to set.
     * @return the SoaRecord object itself.
     */
    public SoaRecord withEmail(String email) {
        this.email = email;
        return this;
    }

    /**
     * Get the serialNumber property: The serial number for this SOA record.
     * 
     * @return the serialNumber value.
     */
    public Long serialNumber() {
        return this.serialNumber;
    }

    /**
     * Set the serialNumber property: The serial number for this SOA record.
     * 
     * @param serialNumber the serialNumber value to set.
     * @return the SoaRecord object itself.
     */
    public SoaRecord withSerialNumber(Long serialNumber) {
        this.serialNumber = serialNumber;
        return this;
    }

    /**
     * Get the refreshTime property: The refresh value for this SOA record.
     * 
     * @return the refreshTime value.
     */
    public Long refreshTime() {
        return this.refreshTime;
    }

    /**
     * Set the refreshTime property: The refresh value for this SOA record.
     * 
     * @param refreshTime the refreshTime value to set.
     * @return the SoaRecord object itself.
     */
    public SoaRecord withRefreshTime(Long refreshTime) {
        this.refreshTime = refreshTime;
        return this;
    }

    /**
     * Get the retryTime property: The retry time for this SOA record.
     * 
     * @return the retryTime value.
     */
    public Long retryTime() {
        return this.retryTime;
    }

    /**
     * Set the retryTime property: The retry time for this SOA record.
     * 
     * @param retryTime the retryTime value to set.
     * @return the SoaRecord object itself.
     */
    public SoaRecord withRetryTime(Long retryTime) {
        this.retryTime = retryTime;
        return this;
    }

    /**
     * Get the expireTime property: The expire time for this SOA record.
     * 
     * @return the expireTime value.
     */
    public Long expireTime() {
        return this.expireTime;
    }

    /**
     * Set the expireTime property: The expire time for this SOA record.
     * 
     * @param expireTime the expireTime value to set.
     * @return the SoaRecord object itself.
     */
    public SoaRecord withExpireTime(Long expireTime) {
        this.expireTime = expireTime;
        return this;
    }

    /**
     * Get the minimumTtl property: The minimum value for this SOA record. By convention this is used to determine the
     * negative caching duration.
     * 
     * @return the minimumTtl value.
     */
    public Long minimumTtl() {
        return this.minimumTtl;
    }

    /**
     * Set the minimumTtl property: The minimum value for this SOA record. By convention this is used to determine the
     * negative caching duration.
     * 
     * @param minimumTtl the minimumTtl value to set.
     * @return the SoaRecord object itself.
     */
    public SoaRecord withMinimumTtl(Long minimumTtl) {
        this.minimumTtl = minimumTtl;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("host", this.host);
        jsonWriter.writeStringField("email", this.email);
        jsonWriter.writeNumberField("serialNumber", this.serialNumber);
        jsonWriter.writeNumberField("refreshTime", this.refreshTime);
        jsonWriter.writeNumberField("retryTime", this.retryTime);
        jsonWriter.writeNumberField("expireTime", this.expireTime);
        jsonWriter.writeNumberField("minimumTTL", this.minimumTtl);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SoaRecord from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SoaRecord if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the SoaRecord.
     */
    public static SoaRecord fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SoaRecord deserializedSoaRecord = new SoaRecord();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("host".equals(fieldName)) {
                    deserializedSoaRecord.host = reader.getString();
                } else if ("email".equals(fieldName)) {
                    deserializedSoaRecord.email = reader.getString();
                } else if ("serialNumber".equals(fieldName)) {
                    deserializedSoaRecord.serialNumber = reader.getNullable(JsonReader::getLong);
                } else if ("refreshTime".equals(fieldName)) {
                    deserializedSoaRecord.refreshTime = reader.getNullable(JsonReader::getLong);
                } else if ("retryTime".equals(fieldName)) {
                    deserializedSoaRecord.retryTime = reader.getNullable(JsonReader::getLong);
                } else if ("expireTime".equals(fieldName)) {
                    deserializedSoaRecord.expireTime = reader.getNullable(JsonReader::getLong);
                } else if ("minimumTTL".equals(fieldName)) {
                    deserializedSoaRecord.minimumTtl = reader.getNullable(JsonReader::getLong);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSoaRecord;
        });
    }
}
