// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.dns.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Represents a single Azure resource and its referencing DNS records.
 */
@Fluent
public final class DnsResourceReference implements JsonSerializable<DnsResourceReference> {
    /*
     * A list of dns Records
     */
    private List<SubResource> dnsResources;

    /*
     * A reference to an azure resource from where the dns resource value is taken.
     */
    private SubResource targetResource;

    /**
     * Creates an instance of DnsResourceReference class.
     */
    public DnsResourceReference() {
    }

    /**
     * Get the dnsResources property: A list of dns Records.
     * 
     * @return the dnsResources value.
     */
    public List<SubResource> dnsResources() {
        return this.dnsResources;
    }

    /**
     * Set the dnsResources property: A list of dns Records.
     * 
     * @param dnsResources the dnsResources value to set.
     * @return the DnsResourceReference object itself.
     */
    public DnsResourceReference withDnsResources(List<SubResource> dnsResources) {
        this.dnsResources = dnsResources;
        return this;
    }

    /**
     * Get the targetResource property: A reference to an azure resource from where the dns resource value is taken.
     * 
     * @return the targetResource value.
     */
    public SubResource targetResource() {
        return this.targetResource;
    }

    /**
     * Set the targetResource property: A reference to an azure resource from where the dns resource value is taken.
     * 
     * @param targetResource the targetResource value to set.
     * @return the DnsResourceReference object itself.
     */
    public DnsResourceReference withTargetResource(SubResource targetResource) {
        this.targetResource = targetResource;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("dnsResources", this.dnsResources, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("targetResource", this.targetResource);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DnsResourceReference from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DnsResourceReference if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DnsResourceReference.
     */
    public static DnsResourceReference fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DnsResourceReference deserializedDnsResourceReference = new DnsResourceReference();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("dnsResources".equals(fieldName)) {
                    List<SubResource> dnsResources = reader.readArray(reader1 -> SubResource.fromJson(reader1));
                    deserializedDnsResourceReference.dnsResources = dnsResources;
                } else if ("targetResource".equals(fieldName)) {
                    deserializedDnsResourceReference.targetResource = SubResource.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDnsResourceReference;
        });
    }
}
