// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.dns.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A CAA record.
 */
@Fluent
public final class CaaRecord implements JsonSerializable<CaaRecord> {
    /*
     * The flags for this CAA record as an integer between 0 and 255.
     */
    private Integer flags;

    /*
     * The tag for this CAA record.
     */
    private String tag;

    /*
     * The value for this CAA record.
     */
    private String value;

    /**
     * Creates an instance of CaaRecord class.
     */
    public CaaRecord() {
    }

    /**
     * Get the flags property: The flags for this CAA record as an integer between 0 and 255.
     * 
     * @return the flags value.
     */
    public Integer flags() {
        return this.flags;
    }

    /**
     * Set the flags property: The flags for this CAA record as an integer between 0 and 255.
     * 
     * @param flags the flags value to set.
     * @return the CaaRecord object itself.
     */
    public CaaRecord withFlags(Integer flags) {
        this.flags = flags;
        return this;
    }

    /**
     * Get the tag property: The tag for this CAA record.
     * 
     * @return the tag value.
     */
    public String tag() {
        return this.tag;
    }

    /**
     * Set the tag property: The tag for this CAA record.
     * 
     * @param tag the tag value to set.
     * @return the CaaRecord object itself.
     */
    public CaaRecord withTag(String tag) {
        this.tag = tag;
        return this;
    }

    /**
     * Get the value property: The value for this CAA record.
     * 
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Set the value property: The value for this CAA record.
     * 
     * @param value the value value to set.
     * @return the CaaRecord object itself.
     */
    public CaaRecord withValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("flags", this.flags);
        jsonWriter.writeStringField("tag", this.tag);
        jsonWriter.writeStringField("value", this.value);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CaaRecord from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CaaRecord if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the CaaRecord.
     */
    public static CaaRecord fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CaaRecord deserializedCaaRecord = new CaaRecord();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("flags".equals(fieldName)) {
                    deserializedCaaRecord.flags = reader.getNullable(JsonReader::getInt);
                } else if ("tag".equals(fieldName)) {
                    deserializedCaaRecord.tag = reader.getString();
                } else if ("value".equals(fieldName)) {
                    deserializedCaaRecord.value = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCaaRecord;
        });
    }
}
