/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dns.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dns.fluent.models.RecordSetProperties;
import com.azure.resourcemanager.dns.models.ARecord;
import com.azure.resourcemanager.dns.models.AaaaRecord;
import com.azure.resourcemanager.dns.models.CaaRecord;
import com.azure.resourcemanager.dns.models.CnameRecord;
import com.azure.resourcemanager.dns.models.MxRecord;
import com.azure.resourcemanager.dns.models.NsRecord;
import com.azure.resourcemanager.dns.models.PtrRecord;
import com.azure.resourcemanager.dns.models.SoaRecord;
import com.azure.resourcemanager.dns.models.SrvRecord;
import com.azure.resourcemanager.dns.models.TxtRecord;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class RecordSetInner
extends ProxyResource {
    private String etag;
    private RecordSetProperties innerProperties;
    private String id;
    private String name;
    private String type;

    public String etag() {
        return this.etag;
    }

    public RecordSetInner withEtag(String etag) {
        this.etag = etag;
        return this;
    }

    private RecordSetProperties innerProperties() {
        return this.innerProperties;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public Map<String, String> metadata() {
        return this.innerProperties() == null ? null : this.innerProperties().metadata();
    }

    public RecordSetInner withMetadata(Map<String, String> metadata) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RecordSetProperties();
        }
        this.innerProperties().withMetadata(metadata);
        return this;
    }

    public Long ttl() {
        return this.innerProperties() == null ? null : this.innerProperties().ttl();
    }

    public RecordSetInner withTtl(Long ttl) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RecordSetProperties();
        }
        this.innerProperties().withTtl(ttl);
        return this;
    }

    public String fqdn() {
        return this.innerProperties() == null ? null : this.innerProperties().fqdn();
    }

    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public SubResource targetResource() {
        return this.innerProperties() == null ? null : this.innerProperties().targetResource();
    }

    public RecordSetInner withTargetResource(SubResource targetResource) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RecordSetProperties();
        }
        this.innerProperties().withTargetResource(targetResource);
        return this;
    }

    public List<ARecord> aRecords() {
        return this.innerProperties() == null ? null : this.innerProperties().aRecords();
    }

    public RecordSetInner withARecords(List<ARecord> aRecords) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RecordSetProperties();
        }
        this.innerProperties().withARecords(aRecords);
        return this;
    }

    public List<AaaaRecord> aaaaRecords() {
        return this.innerProperties() == null ? null : this.innerProperties().aaaaRecords();
    }

    public RecordSetInner withAaaaRecords(List<AaaaRecord> aaaaRecords) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RecordSetProperties();
        }
        this.innerProperties().withAaaaRecords(aaaaRecords);
        return this;
    }

    public List<MxRecord> mxRecords() {
        return this.innerProperties() == null ? null : this.innerProperties().mxRecords();
    }

    public RecordSetInner withMxRecords(List<MxRecord> mxRecords) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RecordSetProperties();
        }
        this.innerProperties().withMxRecords(mxRecords);
        return this;
    }

    public List<NsRecord> nsRecords() {
        return this.innerProperties() == null ? null : this.innerProperties().nsRecords();
    }

    public RecordSetInner withNsRecords(List<NsRecord> nsRecords) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RecordSetProperties();
        }
        this.innerProperties().withNsRecords(nsRecords);
        return this;
    }

    public List<PtrRecord> ptrRecords() {
        return this.innerProperties() == null ? null : this.innerProperties().ptrRecords();
    }

    public RecordSetInner withPtrRecords(List<PtrRecord> ptrRecords) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RecordSetProperties();
        }
        this.innerProperties().withPtrRecords(ptrRecords);
        return this;
    }

    public List<SrvRecord> srvRecords() {
        return this.innerProperties() == null ? null : this.innerProperties().srvRecords();
    }

    public RecordSetInner withSrvRecords(List<SrvRecord> srvRecords) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RecordSetProperties();
        }
        this.innerProperties().withSrvRecords(srvRecords);
        return this;
    }

    public List<TxtRecord> txtRecords() {
        return this.innerProperties() == null ? null : this.innerProperties().txtRecords();
    }

    public RecordSetInner withTxtRecords(List<TxtRecord> txtRecords) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RecordSetProperties();
        }
        this.innerProperties().withTxtRecords(txtRecords);
        return this;
    }

    public CnameRecord cnameRecord() {
        return this.innerProperties() == null ? null : this.innerProperties().cnameRecord();
    }

    public RecordSetInner withCnameRecord(CnameRecord cnameRecord) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RecordSetProperties();
        }
        this.innerProperties().withCnameRecord(cnameRecord);
        return this;
    }

    public SoaRecord soaRecord() {
        return this.innerProperties() == null ? null : this.innerProperties().soaRecord();
    }

    public RecordSetInner withSoaRecord(SoaRecord soaRecord) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RecordSetProperties();
        }
        this.innerProperties().withSoaRecord(soaRecord);
        return this;
    }

    public List<CaaRecord> caaRecords() {
        return this.innerProperties() == null ? null : this.innerProperties().caaRecords();
    }

    public RecordSetInner withCaaRecords(List<CaaRecord> caaRecords) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RecordSetProperties();
        }
        this.innerProperties().withCaaRecords(caaRecords);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("etag", this.etag);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static RecordSetInner fromJson(JsonReader jsonReader) throws IOException {
        return (RecordSetInner)((Object)jsonReader.readObject(reader -> {
            RecordSetInner deserializedRecordSetInner = new RecordSetInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedRecordSetInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedRecordSetInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedRecordSetInner.type = reader.getString();
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedRecordSetInner.etag = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedRecordSetInner.innerProperties = RecordSetProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRecordSetInner;
        }));
    }
}

