/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.DedicatedGatewayType;
import com.azure.resourcemanager.cosmos.models.ServiceResourceProperties;
import com.azure.resourcemanager.cosmos.models.ServiceSize;
import com.azure.resourcemanager.cosmos.models.ServiceStatus;
import com.azure.resourcemanager.cosmos.models.ServiceType;
import com.azure.resourcemanager.cosmos.models.SqlDedicatedGatewayRegionalServiceResource;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class SqlDedicatedGatewayServiceResourceProperties
extends ServiceResourceProperties {
    private ServiceType serviceType = ServiceType.SQL_DEDICATED_GATEWAY;
    private String sqlDedicatedGatewayEndpoint;
    private DedicatedGatewayType dedicatedGatewayType;
    private List<SqlDedicatedGatewayRegionalServiceResource> locations;

    @Override
    public ServiceType serviceType() {
        return this.serviceType;
    }

    public String sqlDedicatedGatewayEndpoint() {
        return this.sqlDedicatedGatewayEndpoint;
    }

    public SqlDedicatedGatewayServiceResourceProperties withSqlDedicatedGatewayEndpoint(String sqlDedicatedGatewayEndpoint) {
        this.sqlDedicatedGatewayEndpoint = sqlDedicatedGatewayEndpoint;
        return this;
    }

    public DedicatedGatewayType dedicatedGatewayType() {
        return this.dedicatedGatewayType;
    }

    public SqlDedicatedGatewayServiceResourceProperties withDedicatedGatewayType(DedicatedGatewayType dedicatedGatewayType) {
        this.dedicatedGatewayType = dedicatedGatewayType;
        return this;
    }

    public List<SqlDedicatedGatewayRegionalServiceResource> locations() {
        return this.locations;
    }

    @Override
    public SqlDedicatedGatewayServiceResourceProperties withInstanceSize(ServiceSize instanceSize) {
        super.withInstanceSize(instanceSize);
        return this;
    }

    @Override
    public SqlDedicatedGatewayServiceResourceProperties withInstanceCount(Integer instanceCount) {
        super.withInstanceCount(instanceCount);
        return this;
    }

    @Override
    public void validate() {
        if (this.locations() != null) {
            this.locations().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("instanceSize", this.instanceSize() == null ? null : this.instanceSize().toString());
        jsonWriter.writeNumberField("instanceCount", (Number)this.instanceCount());
        jsonWriter.writeStringField("serviceType", this.serviceType == null ? null : this.serviceType.toString());
        jsonWriter.writeStringField("sqlDedicatedGatewayEndpoint", this.sqlDedicatedGatewayEndpoint);
        jsonWriter.writeStringField("dedicatedGatewayType", this.dedicatedGatewayType == null ? null : this.dedicatedGatewayType.toString());
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static SqlDedicatedGatewayServiceResourceProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SqlDedicatedGatewayServiceResourceProperties)jsonReader.readObject(reader -> {
            SqlDedicatedGatewayServiceResourceProperties deserializedSqlDedicatedGatewayServiceResourceProperties = new SqlDedicatedGatewayServiceResourceProperties();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("creationTime".equals(fieldName)) {
                    deserializedSqlDedicatedGatewayServiceResourceProperties.withCreationTime((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("instanceSize".equals(fieldName)) {
                    deserializedSqlDedicatedGatewayServiceResourceProperties.withInstanceSize(ServiceSize.fromString(reader.getString()));
                    continue;
                }
                if ("instanceCount".equals(fieldName)) {
                    deserializedSqlDedicatedGatewayServiceResourceProperties.withInstanceCount((Integer)reader.getNullable(JsonReader::getInt));
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedSqlDedicatedGatewayServiceResourceProperties.withStatus(ServiceStatus.fromString(reader.getString()));
                    continue;
                }
                if ("serviceType".equals(fieldName)) {
                    deserializedSqlDedicatedGatewayServiceResourceProperties.serviceType = ServiceType.fromString(reader.getString());
                    continue;
                }
                if ("sqlDedicatedGatewayEndpoint".equals(fieldName)) {
                    deserializedSqlDedicatedGatewayServiceResourceProperties.sqlDedicatedGatewayEndpoint = reader.getString();
                    continue;
                }
                if ("dedicatedGatewayType".equals(fieldName)) {
                    deserializedSqlDedicatedGatewayServiceResourceProperties.dedicatedGatewayType = DedicatedGatewayType.fromString(reader.getString());
                    continue;
                }
                if ("locations".equals(fieldName)) {
                    List locations;
                    deserializedSqlDedicatedGatewayServiceResourceProperties.locations = locations = reader.readArray(reader1 -> SqlDedicatedGatewayRegionalServiceResource.fromJson(reader1));
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedSqlDedicatedGatewayServiceResourceProperties.withAdditionalProperties(additionalProperties);
            return deserializedSqlDedicatedGatewayServiceResourceProperties;
        });
    }
}

