/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.RestoreParametersBase;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class ResourceRestoreParameters
extends RestoreParametersBase {
    @Override
    public ResourceRestoreParameters withRestoreSource(String restoreSource) {
        super.withRestoreSource(restoreSource);
        return this;
    }

    @Override
    public ResourceRestoreParameters withRestoreTimestampInUtc(OffsetDateTime restoreTimestampInUtc) {
        super.withRestoreTimestampInUtc(restoreTimestampInUtc);
        return this;
    }

    @Override
    public ResourceRestoreParameters withRestoreWithTtlDisabled(Boolean restoreWithTtlDisabled) {
        super.withRestoreWithTtlDisabled(restoreWithTtlDisabled);
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("restoreSource", this.restoreSource());
        jsonWriter.writeStringField("restoreTimestampInUtc", this.restoreTimestampInUtc() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.restoreTimestampInUtc()));
        jsonWriter.writeBooleanField("restoreWithTtlDisabled", this.restoreWithTtlDisabled());
        return jsonWriter.writeEndObject();
    }

    public static ResourceRestoreParameters fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceRestoreParameters)jsonReader.readObject(reader -> {
            ResourceRestoreParameters deserializedResourceRestoreParameters = new ResourceRestoreParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("restoreSource".equals(fieldName)) {
                    deserializedResourceRestoreParameters.withRestoreSource(reader.getString());
                    continue;
                }
                if ("restoreTimestampInUtc".equals(fieldName)) {
                    deserializedResourceRestoreParameters.withRestoreTimestampInUtc((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("restoreWithTtlDisabled".equals(fieldName)) {
                    deserializedResourceRestoreParameters.withRestoreWithTtlDisabled((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceRestoreParameters;
        });
    }
}

