/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.FullTextPath;
import java.io.IOException;
import java.util.List;

public final class FullTextPolicy
implements JsonSerializable<FullTextPolicy> {
    private String defaultLanguage;
    private List<FullTextPath> fullTextPaths;

    public String defaultLanguage() {
        return this.defaultLanguage;
    }

    public FullTextPolicy withDefaultLanguage(String defaultLanguage) {
        this.defaultLanguage = defaultLanguage;
        return this;
    }

    public List<FullTextPath> fullTextPaths() {
        return this.fullTextPaths;
    }

    public FullTextPolicy withFullTextPaths(List<FullTextPath> fullTextPaths) {
        this.fullTextPaths = fullTextPaths;
        return this;
    }

    public void validate() {
        if (this.fullTextPaths() != null) {
            this.fullTextPaths().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("defaultLanguage", this.defaultLanguage);
        jsonWriter.writeArrayField("fullTextPaths", this.fullTextPaths, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static FullTextPolicy fromJson(JsonReader jsonReader) throws IOException {
        return (FullTextPolicy)jsonReader.readObject(reader -> {
            FullTextPolicy deserializedFullTextPolicy = new FullTextPolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("defaultLanguage".equals(fieldName)) {
                    deserializedFullTextPolicy.defaultLanguage = reader.getString();
                    continue;
                }
                if ("fullTextPaths".equals(fieldName)) {
                    List fullTextPaths;
                    deserializedFullTextPolicy.fullTextPaths = fullTextPaths = reader.readArray(reader1 -> FullTextPath.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFullTextPolicy;
        });
    }
}

